/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.libnolij.refraction;

import dev.nolij.toomanyrecipeviewers.libnolij.util.UnsafeUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Refraction {
    private static final Refraction PUBLIC = new Refraction(MethodHandles.lookup());
    @NotNull
    private final MethodHandles.Lookup lookup;
    @NotNull
    private final ClassLoader classLoader;

    public static Refraction safe() {
        return PUBLIC;
    }

    public static Refraction unsafe() {
        return UnsafeUtil.UNSAFE_REFRACTION;
    }

    public Refraction(@NotNull MethodHandles.Lookup lookup) {
        this(lookup, lookup.lookupClass().getClassLoader());
    }

    public Refraction(@NotNull MethodHandles.Lookup lookup, @NotNull ClassLoader classLoader) {
        this.lookup = lookup;
        this.classLoader = classLoader;
    }

    @SafeVarargs
    @Nullable
    public static <T> T firstNonNull(T ... options) {
        for (T option : options) {
            if (option == null) continue;
            return option;
        }
        return null;
    }

    @Nullable
    public Class<?> getClassOrNull(@NotNull String className) {
        try {
            return Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @Nullable
    public Class<?> getClassOrNull(String ... classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Nullable
    public MethodHandle getMethodOrNull(@Nullable Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        if (clazz == null || Arrays.stream(parameterTypes).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.lookup.unreflect(clazz.getMethod(methodName, parameterTypes));
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getMethodOrNull(@Nullable Class<?> clazz, @NotNull String methodName, @Nullable MethodType methodType, Class<?> ... parameterTypes) {
        if (clazz == null || Arrays.stream(parameterTypes).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.lookup.unreflect(clazz.getMethod(methodName, parameterTypes)).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getConstructorOrNull(@Nullable Class<?> clazz, @NotNull MethodType methodType, Class<?> ... parameterTypes) {
        if (clazz == null || Arrays.stream(parameterTypes).anyMatch(Objects::isNull)) {
            return null;
        }
        try {
            return this.lookup.unreflectConstructor(clazz.getConstructor(parameterTypes)).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getGetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findGetter(clazz, fieldName, fieldType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getStaticGetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findStaticGetter(clazz, fieldName, fieldType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getGetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType, @NotNull MethodType methodType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findGetter(clazz, fieldName, fieldType).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getStaticGetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType, @NotNull MethodType methodType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findStaticGetter(clazz, fieldName, fieldType).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getSetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findSetter(clazz, fieldName, fieldType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getStaticSetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findStaticSetter(clazz, fieldName, fieldType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getSetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType, @NotNull MethodType methodType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findSetter(clazz, fieldName, fieldType).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public MethodHandle getStaticSetterOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType, @NotNull MethodType methodType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findStaticSetter(clazz, fieldName, fieldType).asType(methodType);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    @Nullable
    public VarHandle getFieldOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findVarHandle(clazz, fieldName, fieldType).withInvokeExactBehavior();
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return null;
        }
    }

    @Nullable
    public VarHandle getStaticFieldOrNull(@Nullable Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        if (clazz == null || fieldType == null) {
            return null;
        }
        try {
            return this.lookup.findStaticVarHandle(clazz, fieldName, fieldType).withInvokeExactBehavior();
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return null;
        }
    }
}

