/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers;

import dev.emi.emi.jemi.JemiPlugin;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.runtime.EmiReloadManager;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewersMod;
import dev.nolij.toomanyrecipeviewers.libnolij.collect.InverseSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.config.IJeiConfigManager;
import mezz.jei.library.plugins.jei.JeiInternalPlugin;
import mezz.jei.library.plugins.vanilla.VanillaPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class JEIPlugins {
    private static final InverseSet<String> forceLoadJEIPluginsFrom = InverseSet.of("emi", "jei", "jei-api", "toomanyrecipeviewers");
    private static final Set<String> modsWithEMIPlugins = JemiUtil.getHandledMods().stream().filter(forceLoadJEIPluginsFrom::contains).collect(Collectors.toUnmodifiableSet());
    public static final List<IModPlugin> allPlugins = new ArrayList<IModPlugin>();
    public static final List<IModPlugin> modPlugins = new ArrayList<IModPlugin>();
    public static final VanillaPlugin vanillaPlugin = new VanillaPlugin();
    private static final Map<IModPlugin, Long> loadTimes;
    private static long loadTime;

    @Deprecated
    private JEIPlugins() {
    }

    private static <T> List<Class<? extends T>> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : scanData.getAnnotations()) {
                if (!Objects.equals(annotation.annotationType(), annotationType)) continue;
                result.add(Objects.requireNonNull(TooManyRecipeViewersMod.REFRACTION.getClassOrNull(annotation.memberName())).asSubclass(instanceClass));
            }
        }
        return result;
    }

    public static void resetLoadTimes() {
        loadTimes.clear();
        loadTime = 0L;
    }

    public static void logLoadTimes() {
        for (IModPlugin plugin : allPlugins) {
            TooManyRecipeViewersMod.LOGGER.info("[{}] Loaded in {}ms", (Object)plugin.getPluginUid(), (Object)loadTimes.get(plugin));
        }
        TooManyRecipeViewersMod.LOGGER.info("JEI plugins loaded in {}ms", (Object)loadTime);
    }

    private static void dispatchInternal(IModPlugin plugin, Consumer<IModPlugin> dispatcher, String callerMethod) {
        long dispatchTime;
        ResourceLocation pluginId = plugin.getPluginUid();
        long pluginTimestamp = System.currentTimeMillis();
        try {
            EmiReloadManager.step((Component)Component.literal((String)"[TMRV] %s: %s...".formatted(callerMethod, pluginId.toString())));
            dispatcher.accept(plugin);
            dispatchTime = System.currentTimeMillis() - pluginTimestamp;
            EmiReloadManager.step((Component)Component.literal((String)"[TMRV] %s: %s took %dms".formatted(callerMethod, pluginId.toString(), dispatchTime)));
        }
        catch (Throwable t) {
            dispatchTime = System.currentTimeMillis() - pluginTimestamp;
            TooManyRecipeViewersMod.LOGGER.error("[{}] {} threw exception after {}ms: ", (Object)pluginId, (Object)callerMethod, (Object)dispatchTime, (Object)t);
        }
        loadTimes.put(plugin, loadTimes.computeIfAbsent(plugin, x -> 0L) + dispatchTime);
    }

    private static void dispatchInternal(List<IModPlugin> plugins, Consumer<IModPlugin> dispatcher, String callerMethod) {
        for (IModPlugin plugin : plugins) {
            JEIPlugins.dispatchInternal(plugin, dispatcher, callerMethod);
        }
    }

    private static void dispatch(List<IModPlugin> plugins, Consumer<IModPlugin> dispatcher, boolean onMainThread) {
        String callerMethod = new Exception().getStackTrace()[1].getMethodName();
        long timestamp = System.currentTimeMillis();
        if (onMainThread) {
            Minecraft.getInstance().executeBlocking(() -> JEIPlugins.dispatchInternal(plugins, dispatcher, callerMethod));
        } else {
            JEIPlugins.dispatchInternal(plugins, dispatcher, callerMethod);
        }
        long totalDispatchTime = System.currentTimeMillis() - timestamp;
        TooManyRecipeViewersMod.LOGGER.info("{} took {}ms", (Object)callerMethod, (Object)totalDispatchTime);
        loadTime += totalDispatchTime;
    }

    public static void registerItemSubtypes(ISubtypeRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerItemSubtypes(registration), false);
    }

    public static <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerFluidSubtypes(registration, platformFluidHelper), false);
    }

    public static void registerIngredients(IModIngredientRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerIngredients(registration), false);
    }

    public static void registerExtraIngredients(IExtraIngredientRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerExtraIngredients(registration), false);
    }

    public static void registerIngredientAliases(IIngredientAliasRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerIngredientAliases(registration), false);
    }

    public static void registerModInfo(IModInfoRegistration modAliasRegistration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerModInfo(modAliasRegistration), false);
    }

    public static void registerCategories(IRecipeCategoryRegistration registration) {
        JEIPlugins.dispatch(allPlugins, x -> x.registerCategories(registration), false);
    }

    public static void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        JEIPlugins.dispatch(allPlugins, x -> x.registerVanillaCategoryExtensions(registration), false);
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerRecipes(registration), true);
    }

    public static void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerRecipeTransferHandlers(registration), false);
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerRecipeCatalysts(registration), false);
    }

    public static void registerGuiHandlers(IGuiHandlerRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerGuiHandlers(registration), false);
    }

    public static void registerAdvanced(IAdvancedRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerAdvanced(registration), false);
    }

    public static void registerRuntime(IRuntimeRegistration registration) {
        JEIPlugins.dispatch(modPlugins, x -> x.registerRuntime(registration), false);
    }

    public static void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIPlugins.dispatch(modPlugins, x -> x.onRuntimeAvailable(jeiRuntime), true);
    }

    public static void onRuntimeUnavailable() {
        JEIPlugins.dispatch(modPlugins, IModPlugin::onRuntimeUnavailable, false);
    }

    public static void onConfigManagerAvailable(IJeiConfigManager configManager) {
        JEIPlugins.dispatch(modPlugins, x -> x.onConfigManagerAvailable(configManager), false);
    }

    static {
        List<Class<IModPlugin>> pluginClasses = JEIPlugins.getInstances(JeiPlugin.class, IModPlugin.class);
        pluginClasses.remove(JemiPlugin.class);
        pluginClasses.remove(VanillaPlugin.class);
        pluginClasses.remove(JeiInternalPlugin.class);
        pluginClasses.addLast(JeiInternalPlugin.class);
        allPlugins.add(vanillaPlugin);
        for (Class<IModPlugin> pluginClass : pluginClasses) {
            ResourceLocation pluginID;
            IModPlugin plugin;
            try {
                plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                TooManyRecipeViewersMod.LOGGER.error("Failed to initialize JEI plugin {}", (Object)pluginClass.getName(), (Object)t);
                continue;
            }
            try {
                pluginID = Objects.requireNonNull(plugin.getPluginUid());
            }
            catch (Throwable t) {
                TooManyRecipeViewersMod.LOGGER.error("{}.getPluginUid() threw an exception or returned null", (Object)pluginClass.getName(), (Object)t);
                continue;
            }
            if (modsWithEMIPlugins.contains(pluginID.getNamespace())) continue;
            allPlugins.add(plugin);
            modPlugins.add(plugin);
        }
        loadTimes = Collections.synchronizedMap(new HashMap());
        loadTime = 0L;
    }
}

