/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.registry;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockRegistryObjectGroup<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<B> {
    private final String name;
    private final Supplier<B> blockCreator;
    private final Function<B, I> itemCreator;
    private final BlockEntityType.BlockEntitySupplier<T> tileSupplier;
    private DeferredHolder<Block, B> block;
    private DeferredHolder<Item, I> item;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> tileEntity;

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator) {
        this(name, blockCreator, itemCreator, null);
    }

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator, Supplier<T> tileSupplier) {
        this.name = name;
        this.blockCreator = blockCreator;
        this.itemCreator = itemCreator;
        this.tileSupplier = (p_155268_, p_155269_) -> (BlockEntity)tileSupplier.get();
    }

    @Nonnull
    public B getBlock() {
        return (B)((Block)Objects.requireNonNull(this.block).get());
    }

    @Nonnull
    public I getItem() {
        return (I)((Item)Objects.requireNonNull(this.item).get());
    }

    @Nonnull
    public BlockEntityType<T> getTileEntityType() {
        return (BlockEntityType)Objects.requireNonNull(this.tileEntity).get();
    }

    public BlockRegistryObjectGroup<B, I, ?> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry) {
        this.block = blockRegistry.register(this.name, this.blockCreator);
        this.item = itemRegistry.register(this.name, () -> (Item)this.itemCreator.apply(this.getBlock()));
        return this;
    }

    public BlockRegistryObjectGroup<B, I, T> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<BlockEntityType<?>> tileEntityTypeRegistry) {
        this.register(blockRegistry, itemRegistry);
        if (this.tileSupplier != null) {
            this.tileEntity = tileEntityTypeRegistry.register(this.name, () -> BlockEntityType.Builder.of(this.tileSupplier, (Block[])new Block[]{this.getBlock()}).build(null));
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public B get() {
        return this.getBlock();
    }
}

