/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.util;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntitySection;

public class EntityUtil {
    public static void spawnEntityClientSide(Level level, Entity entity, boolean onlyInTickingChunks) {
        DistHelper.spawnEntityClientSide(level, entity, onlyInTickingChunks);
    }

    private static class DistHelper {
        private DistHelper() {
        }

        public static void spawnEntityClientSide(Level level, Entity entity, boolean onlyInTickingChunks) {
            if (level instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)level;
                long sectionPos = SectionPos.asLong((BlockPos)entity.blockPosition());
                EntitySection section = clientLevel.entityStorage.sectionStorage.getOrCreateSection(sectionPos);
                if (onlyInTickingChunks && !section.getStatus().isTicking()) {
                    return;
                }
                clientLevel.addEntity(entity);
            }
        }
    }
}

