/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.scanner;

import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Scanner {
    public int totalTicks;
    protected Set<Block> targets;
    protected Player player;
    protected Vec3 center;
    protected float radius;
    protected float radiusSquared;
    protected BlockPos min;
    protected BlockPos max;
    protected int x;
    protected int y;
    protected int z;
    private int blocksPerTick;

    public Scanner(Set<Block> targets) {
        this.targets = targets;
    }

    public void initialize(Player player, Vec3 center, float radius, int totalTicks) {
        this.totalTicks = totalTicks;
        this.player = player;
        this.center = center;
        this.radius = radius;
        this.radiusSquared = this.radius * this.radius;
        this.min = BlockPos.containing((Position)center).offset(Mth.ceil((float)(-this.radius)), Mth.ceil((float)(-this.radius)), Mth.ceil((float)(-this.radius)));
        this.max = BlockPos.containing((Position)center).offset(Mth.ceil((float)this.radius), Mth.ceil((float)this.radius), Mth.ceil((float)this.radius));
        this.x = this.min.getX();
        this.y = this.min.getY() - 1;
        this.z = this.min.getZ();
        BlockPos size = this.max.subtract((Vec3i)this.min);
        int blockCount = (size.getX() + 1) * (size.getY() + 1) * (size.getZ() + 1);
        this.blocksPerTick = Mth.ceil((float)((float)blockCount / (float)totalTicks));
    }

    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
        this.radiusSquared = 0.0f;
        this.min = null;
        this.max = null;
    }

    public void scan(Consumer<BlockPos> resultConsumer) {
        Level level = this.player.level();
        for (int i = 0; i < this.blocksPerTick; ++i) {
            BlockPos pos;
            BlockState state;
            if (!this.nextBlock(level)) {
                return;
            }
            if (this.center.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)this.radiusSquared || !this.isValidBlock(state = level.getBlockState(pos = new BlockPos(this.x, this.y, this.z)))) continue;
            resultConsumer.accept(pos);
        }
    }

    public boolean nextBlock(Level level) {
        ++this.y;
        if (this.y > this.max.getY() || this.y >= level.getHeight()) {
            this.y = this.min.getY();
            ++this.x;
            if (this.x > this.max.getX()) {
                this.x = this.min.getX();
                ++this.z;
                if (this.z > this.max.getZ()) {
                    this.blocksPerTick = 0;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isValidBlock(BlockState state) {
        return this.targets.contains(state.getBlock());
    }
}

