/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.item.divinationrod.DivinationRodItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.integration.jei.DivinationRodSubtypeInterpreter;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.integration.jei.recipes.AccumulationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.CalcinationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.DigestionCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.DistillationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.FermentationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.IncubationCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.LiquefactionCategory;
import com.klikli_dev.theurgy.integration.jei.recipes.ReformationCategory;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Theurgy.loc("jei_plugin");
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof DivinationRodItem).forEach(item -> {
            registration.registerSubtypeInterpreter((Item)item.get(), (IIngredientSubtypeInterpreter)DivinationRodSubtypeInterpreter.get());
            Theurgy.LOGGER.debug("Registered Divination Rod JEI Subtype Interpreter for: {}", (Object)item.getKey());
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CalcinationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new LiquefactionCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DistillationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AccumulationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReformationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FermentationCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DigestionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = level.getRecipeManager();
        List calcinationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CALCINATION.get());
        registration.addRecipes(JeiRecipeTypes.CALCINATION, calcinationRecipes);
        List liquefactionRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
        registration.addRecipes(JeiRecipeTypes.LIQUEFACTION, liquefactionRecipes);
        List distillationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.DISTILLATION.get());
        registration.addRecipes(JeiRecipeTypes.DISTILLATION, distillationRecipes);
        List incubationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.INCUBATION.get());
        registration.addRecipes(JeiRecipeTypes.INCUBATION, incubationRecipes);
        List accumulationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.ACCUMULATION.get());
        registration.addRecipes(JeiRecipeTypes.ACCUMULATION, accumulationRecipes);
        List<ItemStack> sulfursWithoutRecipe = SulfurRegistry.SULFURS.getEntries().stream().map(DeferredHolder::get).map(AlchemicalSulfurItem.class::cast).filter(sulfur -> liquefactionRecipes.stream().noneMatch(r -> ((LiquefactionRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()) != null && ((LiquefactionRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() == sulfur)).map(ItemStack::new).toList();
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, sulfursWithoutRecipe);
        List<RecipeHolder> reformationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.REFORMATION.get()).stream().filter(r -> ((ReformationRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()) != null).filter(r -> sulfursWithoutRecipe.stream().noneMatch(s -> s.getItem() == ((ReformationRecipe)r.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem())).toList();
        registration.addRecipes(JeiRecipeTypes.REFORMATION, reformationRecipes);
        List fermentationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.FERMENTATION.get());
        registration.addRecipes(JeiRecipeTypes.FERMENTATION, fermentationRecipes);
        List digestionRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.DIGESTION.get());
        registration.addRecipes(JeiRecipeTypes.DIGESTION, digestionRecipes);
        this.registerIngredientInfo(registration, (ItemLike)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get());
    }

    public void registerIngredientInfo(IRecipeRegistration registration, ItemLike ingredient) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ingredient.asItem()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("jei.theurgy.ingredient." + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath() + ".description"))});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CALCINATION_OVEN.get()), new RecipeType[]{JeiRecipeTypes.CALCINATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.LIQUEFACTION_CAULDRON.get()), new RecipeType[]{JeiRecipeTypes.LIQUEFACTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.DISTILLER.get()), new RecipeType[]{JeiRecipeTypes.DISTILLATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.INCUBATOR.get()), new RecipeType[]{JeiRecipeTypes.INCUBATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()), new RecipeType[]{JeiRecipeTypes.ACCUMULATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SULFURIC_FLUX_EMITTER.get()), new RecipeType[]{JeiRecipeTypes.REFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.REFORMATION_TARGET_PEDESTAL.get()), new RecipeType[]{JeiRecipeTypes.REFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.REFORMATION_SOURCE_PEDESTAL.get()), new RecipeType[]{JeiRecipeTypes.REFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get()), new RecipeType[]{JeiRecipeTypes.REFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.FERMENTATION_VAT.get()), new RecipeType[]{JeiRecipeTypes.FERMENTATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.DIGESTION_VAT.get()), new RecipeType[]{JeiRecipeTypes.DIGESTION});
    }
}

