/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ChiseledBookshelfProcessor
extends StructureProcessor {
    public static final MapCodec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("allowed_book_enchantments").forGetter(config -> config.allowedBookEnchantments), (App)IntProvider.codec((int)0, (int)6).optionalFieldOf("number_of_books").forGetter(config -> config.numberOfBooks), (App)IntProvider.codec((int)0, (int)6).optionalFieldOf("number_of_enchanted").forGetter(config -> config.numberOfEnchanted)).apply((Applicative)instance, instance.stable(ChiseledBookshelfProcessor::new)));
    public final Optional<HolderSet<Enchantment>> allowedBookEnchantments;
    public final Optional<IntProvider> numberOfBooks;
    public final Optional<IntProvider> numberOfEnchanted;

    public ChiseledBookshelfProcessor(Optional<HolderSet<Enchantment>> allowedBookEnchantments, Optional<IntProvider> numberOfBooks, Optional<IntProvider> numberOfEnchanted) {
        this.allowedBookEnchantments = allowedBookEnchantments;
        this.numberOfBooks = numberOfBooks;
        this.numberOfEnchanted = numberOfEnchanted;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (structureBlockInfoWorld.state().is(Blocks.CHISELED_BOOKSHELF) && this.numberOfBooks.isPresent() && this.numberOfEnchanted.isPresent() && this.allowedBookEnchantments.isPresent() && this.allowedBookEnchantments.get().size() > 0) {
            NonNullList items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
            RandomSource randomSource = settings.getRandom(structureBlockInfoWorld.pos());
            int maxNumberOfBooks = this.numberOfBooks.get().sample(randomSource);
            int maxNumberOfEnchanted = this.numberOfEnchanted.get().sample(randomSource);
            int currentNumOfEnchanted = 0;
            BlockState chiseledBookshelfState = structureBlockInfoWorld.state();
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(0), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(1), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(2), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(3), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(4), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(5), (Comparable)Boolean.valueOf(false));
            for (int bookNum = 0; bookNum < maxNumberOfBooks; ++bookNum) {
                Optional enchantment;
                ItemStack book = Items.BOOK.getDefaultInstance();
                if (currentNumOfEnchanted < maxNumberOfEnchanted && (enchantment = this.allowedBookEnchantments.get().getRandomElement(randomSource)).isPresent()) {
                    book = Items.ENCHANTED_BOOK.getDefaultInstance();
                    book.enchant((Holder)enchantment.get(), randomSource.nextIntBetweenInclusive(((Enchantment)((Holder)enchantment.get()).value()).getMinLevel(), ((Enchantment)((Holder)enchantment.get()).value()).getMaxLevel()));
                    ++currentNumOfEnchanted;
                }
                int index = randomSource.nextInt(6);
                while (!((ItemStack)items.get(index)).isEmpty()) {
                    index = randomSource.nextInt(6);
                }
                items.set(index, (Object)book);
                chiseledBookshelfState = (BlockState)chiseledBookshelfState.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(index), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag tag = structureBlockInfoWorld.nbt() == null ? new CompoundTag() : structureBlockInfoWorld.nbt().copy();
            ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)items, (boolean)true, (HolderLookup.Provider)levelReader.registryAccess());
            tag.remove("last_interacted_slot");
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), chiseledBookshelfState, tag);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.CHISELED_BOOKSHELF_PROCESSOR.get();
    }
}

