/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.FloralFillWithRootminConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class FloralFillWithRootmin
extends Feature<FloralFillWithRootminConfig> {
    public FloralFillWithRootmin(Codec<FloralFillWithRootminConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<FloralFillWithRootminConfig> context) {
        WorldGenLevel level = context.level();
        RandomSource randomSource = context.random();
        FloralFillWithRootminConfig config = (FloralFillWithRootminConfig)context.config();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos chunkCornerPos = new ChunkPos(context.origin()).getWorldPosition().above(context.origin().getY());
        Optional optionalBlocks = BuiltInRegistries.BLOCK.getTag(config.flowerTag);
        List blockList = GeneralUtils.convertHoldersetToList(optionalBlocks);
        blockList.removeIf(block -> block.defaultBlockState().is(((FloralFillWithRootminConfig)context.config()).disallowedFlowerTag));
        if (blockList.isEmpty()) {
            return false;
        }
        ChunkAccess cachedChunk = level.getChunk(chunkCornerPos);
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        for (int xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                boolean spawnRootmin = false;
                boolean spawnFlower = false;
                if (randomSource.nextFloat() < config.rootminChance) {
                    spawnRootmin = true;
                } else if (randomSource.nextFloat() < config.flowerChance) {
                    spawnFlower = true;
                }
                if (!spawnRootmin && !spawnFlower) continue;
                mutable.set((Vec3i)chunkCornerPos).move(xOffset, 0, zOffset);
                boolean isAtGrassBlock = this.setMutableToGrassBlock(cachedChunk, bulkSectionAccess, mutable);
                if (!isAtGrassBlock || mutable.getY() <= cachedChunk.getMinBuildHeight() || mutable.getY() >= cachedChunk.getMaxBuildHeight() || !bulkSectionAccess.getBlockState(mutable.above()).isAir()) continue;
                BlockState chosenFlower = ((Block)blockList.get(randomSource.nextInt(blockList.size()))).defaultBlockState();
                if (chosenFlower.hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT)) {
                    chosenFlower = (BlockState)chosenFlower.setValue((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable)Integer.valueOf(4));
                }
                if (chosenFlower.getBlock() instanceof DoublePlantBlock) {
                    chosenFlower = (BlockState)chosenFlower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                }
                if (spawnRootmin && mutable.getY() != 39) {
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.AIR.defaultBlockState(), false);
                    Entity spawningEntity = ((EntityType)BzEntities.ROOTMIN.get()).create((Level)level.getLevel());
                    if (!(spawningEntity instanceof RootminEntity)) continue;
                    RootminEntity rootmin = (RootminEntity)spawningEntity;
                    Optional optionalRootminBlocks = BuiltInRegistries.BLOCK.getTag(config.rootminFlowerTag);
                    List rootminBlockList = GeneralUtils.convertHoldersetToList(optionalRootminBlocks);
                    rootminBlockList.removeIf(block -> block.defaultBlockState().is(((FloralFillWithRootminConfig)context.config()).disallowedRootminFlowerTag));
                    BlockState chosenRootminFlower = blockList.isEmpty() ? Blocks.AIR.defaultBlockState() : ((Block)rootminBlockList.get(randomSource.nextInt(rootminBlockList.size()))).defaultBlockState();
                    rootmin.setPersistenceRequired();
                    rootmin.setFlowerBlock(chosenRootminFlower);
                    rootmin.moveTo((double)mutable.getX() + 0.5, mutable.getY(), (double)mutable.getZ() + 0.5, 0.0f, 0.0f);
                    rootmin.hideAsBlock(new Vec3((double)mutable.getX() + 0.5, (double)mutable.getY(), (double)mutable.getZ() + 0.5));
                    rootmin.yHeadRot = 0.0f;
                    rootmin.yHeadRotO = 0.0f;
                    rootmin.yBodyRot = 0.0f;
                    rootmin.yBodyRotO = 0.0f;
                    rootmin.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt((BlockPos)mutable), MobSpawnType.CHUNK_GENERATION, null);
                    level.addFreshEntityWithPassengers((Entity)rootmin);
                    mutable.move(Direction.UP);
                    BlockState aboveState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!aboveState.is(BlockTags.REPLACEABLE)) continue;
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.AIR.defaultBlockState(), false);
                    if (!(aboveState.getBlock() instanceof DoublePlantBlock)) continue;
                    mutable.move(Direction.UP);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.AIR.defaultBlockState(), false);
                    continue;
                }
                if (chosenFlower.getBlock() instanceof DoublePlantBlock) {
                    mutable.move(Direction.UP, 2);
                    BlockState aboveState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!aboveState.isAir() && !aboveState.is(BlockTags.REPLACEABLE)) continue;
                    mutable.move(Direction.DOWN);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
                    chosenFlower = (BlockState)chosenFlower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                    mutable.move(Direction.UP);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
                    continue;
                }
                mutable.move(Direction.UP);
                bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
            }
        }
        return true;
    }

    private boolean setMutableToGrassBlock(ChunkAccess cachedChunk, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos.MutableBlockPos mutable) {
        BlockState currentState = bulkSectionAccess.getBlockState((BlockPos)mutable);
        Direction previousDirection = null;
        while (!currentState.is(Blocks.GRASS_BLOCK) && mutable.getY() > cachedChunk.getMinBuildHeight() && mutable.getY() < cachedChunk.getMaxBuildHeight()) {
            if (currentState.is(Blocks.CAVE_AIR)) {
                if (previousDirection == Direction.DOWN) {
                    return false;
                }
                mutable.move(Direction.UP);
                previousDirection = Direction.UP;
            } else if (currentState.isAir() || !currentState.getFluidState().isEmpty()) {
                if (previousDirection == Direction.UP) {
                    return false;
                }
                mutable.move(Direction.DOWN);
                previousDirection = Direction.DOWN;
            } else {
                if (previousDirection == Direction.DOWN) {
                    return false;
                }
                mutable.move(Direction.UP);
                previousDirection = Direction.UP;
            }
            currentState = bulkSectionAccess.getBlockState((BlockPos)mutable);
        }
        return currentState.is(Blocks.GRASS_BLOCK);
    }
}

