/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.NoSuchElementException;
import java.util.function.BooleanSupplier;

public class OptionalBoolean {
    public static final OptionalBoolean EMPTY = new OptionalBoolean();
    public static final OptionalBoolean TRUE = new OptionalBoolean(true);
    public static final OptionalBoolean FALSE = new OptionalBoolean(false);
    private final boolean value;
    private final boolean isPresent;

    private OptionalBoolean(boolean value) {
        this.value = value;
        this.isPresent = true;
    }

    private OptionalBoolean() {
        this.value = false;
        this.isPresent = false;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public void ifPresent(BooleanConsumer consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public boolean orElseGet(BooleanSupplier supplier) {
        return this.isPresent() ? this.value : supplier.getAsBoolean();
    }

    public boolean get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public static OptionalBoolean of(boolean value) {
        return new OptionalBoolean(value);
    }
}

