/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.TwilightForestCompatService;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.EnumSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class TwilightForestCompat
implements ModCompat {
    private static final String ENDER_BOW_ATTACHED_TAG = "twilightforest:ender";
    private static final ResourceLocation ENDER_BOW_RL = ResourceLocation.fromNamespaceAndPath((String)"twilightforest", (String)"ender_bow");

    public TwilightForestCompat() {
        ModChecker.twilightForestPresent = true;
    }

    @Override
    public InteractionResult isProjectileTeleportHandled(HitResult hitResult, Entity owner, Projectile projectile) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (projectile != null && TwilightForestCompatService.INSTANCE.getPersistentData((Entity)projectile).getBoolean(ENDER_BOW_ATTACHED_TAG) && GeneralUtils.isInTag(BuiltInRegistries.ITEM, BzTags.ITEM_SPECIAL_DEDICATED_COMPAT, (Item)BuiltInRegistries.ITEM.get(ENDER_BOW_RL))) {
                return EntityTeleportationHookup.runEntityHitCheck((HitResult)entityHitResult, owner, projectile) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.PROJECTILE_IMPACT_HANDLED);
    }
}

