/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ItemStackSmeltingRecipe
extends SmeltingRecipe {
    protected final RecipeType<?> type = RecipeType.SMELTING;
    protected final CookingBookCategory category;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;

    public ItemStackSmeltingRecipe(String string, CookingBookCategory cookingBookCategory, Ingredient ingredient, ItemStack itemStack, float f, int i) {
        super(string, cookingBookCategory, ingredient, itemStack, f, i);
        this.category = cookingBookCategory;
        this.group = string;
        this.ingredient = ingredient;
        this.result = itemStack;
        this.experience = f;
        this.cookingTime = i;
    }

    public boolean matches(SingleRecipeInput craftingInput, Level level) {
        return this.ingredient.test(craftingInput.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput craftingInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonNullList = NonNullList.create();
        nonNullList.add((Object)this.ingredient);
        return nonNullList;
    }

    public float getExperience() {
        return this.experience;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public String getGroup() {
        return this.group;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public CookingBookCategory category() {
        return this.category;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Blocks.FURNACE);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BzRecipes.ITEMSTACK_SMELTING_RECIPE.get();
    }

    public static class ItemStackSmeltingRecipeSerializer
    implements RecipeSerializer<ItemStackSmeltingRecipe> {
        private final MapCodec<ItemStackSmeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(abstractCookingRecipe -> abstractCookingRecipe.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(abstractCookingRecipe -> abstractCookingRecipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(abstractCookingRecipe -> abstractCookingRecipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(abstractCookingRecipe -> abstractCookingRecipe.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(abstractCookingRecipe -> Float.valueOf(abstractCookingRecipe.experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)200).forGetter(abstractCookingRecipe -> abstractCookingRecipe.cookingTime)).apply((Applicative)instance, ItemStackSmeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackSmeltingRecipe> STREAM_CODEC = StreamCodec.of(ItemStackSmeltingRecipeSerializer::toNetwork, ItemStackSmeltingRecipeSerializer::fromNetwork);

        public MapCodec<ItemStackSmeltingRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemStackSmeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ItemStackSmeltingRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String string = friendlyByteBuf.readUtf();
            CookingBookCategory cookingBookCategory = (CookingBookCategory)friendlyByteBuf.readEnum(CookingBookCategory.class);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            float f = friendlyByteBuf.readFloat();
            int i = friendlyByteBuf.readVarInt();
            return new ItemStackSmeltingRecipe(string, cookingBookCategory, ingredient, itemStack, f, i);
        }

        public static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ItemStackSmeltingRecipe itemStackSmeltingRecipe) {
            friendlyByteBuf.writeUtf(itemStackSmeltingRecipe.group);
            friendlyByteBuf.writeEnum((Enum)itemStackSmeltingRecipe.category());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)itemStackSmeltingRecipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)itemStackSmeltingRecipe.result);
            friendlyByteBuf.writeFloat(itemStackSmeltingRecipe.experience);
            friendlyByteBuf.writeVarInt(itemStackSmeltingRecipe.cookingTime);
        }
    }
}

