/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.SugarWaterFluid;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class GlassBottleBehavior {
    public static ItemStack useBottleOnSugarWater(BottleItem bottleItem, Level world, Player playerEntity, InteractionHand playerHand, BlockPos blockPos) {
        if (world.getFluidState(blockPos).getType() instanceof SugarWaterFluid) {
            ItemStack handStack = playerEntity.getItemInHand(playerHand);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)bottleItem));
            return ItemUtils.createFilledResult((ItemStack)handStack, (Player)playerEntity, (ItemStack)((Item)BzItems.SUGAR_WATER_BOTTLE.get()).getDefaultInstance());
        }
        return ItemStack.EMPTY;
    }

    public static boolean useBottleOnBzHoneyLikeFluid(Level world, Player playerEntity, InteractionHand playerHand, BlockPos blockPos) {
        FluidState currentFluidState = world.getFluidState(blockPos);
        if (currentFluidState.is(BzTags.ROYAL_JELLY_FLUID) && currentFluidState.isSource()) {
            MutableComponent message = Component.translatable((String)"system.the_bumblezone.royal_jelly_bottle.cannot_take_from_source_block").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.LIGHT_PURPLE);
            playerEntity.displayClientMessage((Component)message, true);
            return false;
        }
        return GlassBottleBehavior.convertHoneyFluidToBottleForm(world, playerEntity, playerHand, blockPos, currentFluidState, BzTags.BZ_HONEY_FLUID, Items.HONEY_BOTTLE);
    }

    private static boolean convertHoneyFluidToBottleForm(Level world, Player playerEntity, InteractionHand playerHand, BlockPos blockPos, FluidState currentFluidState, TagKey<Fluid> fluidTag, Item resultItem) {
        if (currentFluidState.is(fluidTag) && currentFluidState.isSource()) {
            world.setBlock(blockPos, (BlockState)currentFluidState.createLegacyBlock().setValue((Property)HoneyFluidBlock.LEVEL, (Comparable)Integer.valueOf(5)), 3);
            world.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)resultItem), false, true);
            world.playSound(playerEntity, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            world.gameEvent((Entity)playerEntity, (Holder)GameEvent.FLUID_PICKUP, blockPos);
            return true;
        }
        return false;
    }
}

