/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.BzArmor;
import com.telepathicgrunt.the_bumblezone.modcompat.BackpackedCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class BeeArmor
extends BzArmor {
    private final int variant;
    private final boolean transTexture;

    public BeeArmor(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties, int variant, boolean transTexture) {
        super(material, armorType, properties);
        this.variant = variant;
        this.transTexture = transTexture;
    }

    public boolean hasTransTexture() {
        return this.transTexture;
    }

    public int getVariant() {
        return this.variant;
    }

    public static int getBeeThemedWearablesCount(Entity entity) {
        int beeWearablesCount = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (ItemStack armor : livingEntity.getArmorSlots()) {
                if (!armor.is(BzTags.BZ_ARMOR_ABILITY_ENHANCING_WEARABLES) || !BeeArmor.isAllowedBeeArmorBoosting(armor)) continue;
                ++beeWearablesCount;
            }
        }
        for (ModCompat compat : ModChecker.CUSTOM_EQUIPMENT_SLOTS_COMPATS) {
            beeWearablesCount += compat.getNumberOfMatchingEquippedItemsInCustomSlots(entity, itemStack -> {
                if (itemStack.is(BzTags.BZ_ARMOR_ABILITY_ENHANCING_WEARABLES)) {
                    return !ModChecker.backpackedPresent || BackpackedCompat.isBackpackedHoneyThemedOrOtherItem(itemStack);
                }
                return false;
            });
        }
        return beeWearablesCount;
    }

    private static boolean isAllowedBeeArmorBoosting(ItemStack armor) {
        for (ModCompat compat : ModChecker.BEE_WEARABLES_BOOSTING_COMPATS) {
            if (!compat.isItemExplicitlyDisallowedFromBeeWearablesBoosting(armor)) continue;
            return false;
        }
        return true;
    }
}

