/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamresourceful.resourcefullib.client.fluid.data.ClientFluidProperties;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.FluidClientOverlay;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.HoneyFluidRendering;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class RoyalJellyClientProperties {
    public static final ResourceLocation ROYAL_JELLY_FLUID_STILL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/royal_jelly_fluid/still");
    public static final ResourceLocation ROYAL_JELLY_FLUID_FLOWING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/royal_jelly_fluid/flow");
    public static final ResourceLocation ROYAL_JELLY_FLUID_FLOWING_DIAGONAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"block/royal_jelly_fluid/flow_diagonal");

    public static ClientFluidProperties create() {
        return new ClientFluidProperties(){

            public ResourceLocation still(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return ROYAL_JELLY_FLUID_STILL_TEXTURE;
            }

            public ResourceLocation flowing(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return ROYAL_JELLY_FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation flowingDiagonal(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return ROYAL_JELLY_FLUID_FLOWING_DIAGONAL_TEXTURE;
            }

            public ResourceLocation overlay(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return ROYAL_JELLY_FLUID_FLOWING_TEXTURE;
            }

            public ResourceLocation screenOverlay() {
                return null;
            }

            public void renderOverlay(Minecraft minecraft, PoseStack stack) {
                FluidClientOverlay.renderHoneyOverlay((Player)minecraft.player, stack);
            }

            public int tintColor(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
                return -1;
            }

            public boolean renderFluid(BlockPos pos, BlockAndTintGetter level, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, Function<ResourceLocation, TextureAtlasSprite> sprites) {
                TextureAtlasSprite[] textureAtlasSprites = new TextureAtlasSprite[]{sprites.apply(this.still(level, pos, fluidState)), sprites.apply(this.flowing(level, pos, fluidState)), sprites.apply(this.overlay(level, pos, fluidState)), sprites.apply(this.flowingDiagonal(level, pos, fluidState))};
                HoneyFluidRendering.renderSpecialHoneyFluid(pos, level, vertexConsumer, blockState, fluidState, textureAtlasSprites);
                return true;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                Entity entity = camera.getEntity();
                BlockState state = level.getBlockState(entity != null ? BlockPos.containing((Position)entity.getEyePosition(1.0f)) : camera.getBlockPosition());
                if (state.hasProperty((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                    double yEye = Math.abs(entity != null ? entity.getEyePosition(1.0f).y() : camera.getPosition().y());
                    double yOffset = yEye - (double)((int)yEye);
                    if ((double)((Integer)state.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                        return fluidFogColor;
                    }
                }
                BlockPos blockpos = BlockPos.containing((double)camera.getEntity().getX(), (double)camera.getEntity().getEyeY(), (double)camera.getEntity().getZ());
                float brightnessAtEyes = LightTexture.getBrightness((DimensionType)camera.getEntity().level().dimensionType(), (int)camera.getEntity().level().getMaxLocalRawBrightness(blockpos));
                float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes(camera.getEntity()), 2.0), (double)brightnessAtEyes);
                float fogRed = 0.5f * brightness;
                float fogGreen = 0.0f;
                float fogBlue = 0.55f * brightness;
                return new Vector3f(fogRed, fogGreen, fogBlue);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                BlockState state;
                Entity entity = camera.getEntity();
                if (entity != null && (state = entity.level().getBlockState(BlockPos.containing((Position)entity.getEyePosition(1.0f)))).hasProperty((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                    double yEye = Math.abs(entity.getEyePosition(1.0f).y());
                    double yOffset = yEye - (double)((int)yEye);
                    if ((double)((Integer)state.getValue((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                        return;
                    }
                }
                RenderSystem.setShaderFogStart((float)0.35f);
                RenderSystem.setShaderFogEnd((float)4.0f);
            }
        };
    }
}

