/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;

public class SugarInfusedCobblestone
extends Block {
    public static final MapCodec<SugarInfusedCobblestone> CODEC = Block.simpleCodec(SugarInfusedCobblestone::new);

    public SugarInfusedCobblestone() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    }

    public SugarInfusedCobblestone(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends SugarInfusedCobblestone> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        SugarInfusedCobblestone.sugarifyNeighboringWater((LevelAccessor)level, blockPos);
        super.neighborChanged(blockState, level, blockPos, block, blockPos1, b);
    }

    public void onPlace(BlockState blockState, Level world, BlockPos blockPos, BlockState previousBlockState, boolean notify) {
        SugarInfusedCobblestone.sugarifyNeighboringWater((LevelAccessor)world, blockPos);
        super.onPlace(blockState, world, blockPos, previousBlockState, notify);
    }

    private static void sugarifyNeighboringWater(LevelAccessor level, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = blockPos.relative(direction);
            FluidState sideFluid = level.getFluidState(sidePos);
            if (!sideFluid.is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) || sideFluid.is(BzTags.SUGAR_WATER_FLUID) || !sideFluid.isSource() || !level.getBlockState(sidePos).getShape((BlockGetter)level, sidePos).isEmpty()) continue;
            level.setBlock(sidePos, ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState(), 3);
        }
    }
}

