/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.StickyHoneyResidue;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class StickyHoneyRedstone
extends StickyHoneyResidue {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final MapCodec<StickyHoneyRedstone> CODEC = Block.simpleCodec(StickyHoneyRedstone::new);

    public StickyHoneyRedstone() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).lightLevel(blockState -> (Boolean)blockState.getValue((Property)POWERED) != false ? 1 : 0).noCollission().strength(6.0f, 0.0f).noOcclusion().replaceable().pushReaction(PushReaction.DESTROY));
    }

    public StickyHoneyRedstone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends StickyHoneyRedstone> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[0]).add(new Property[]{UP, NORTH, EAST, SOUTH, WEST, DOWN, POWERED});
    }

    @Override
    @Deprecated
    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        this.updateState(level, blockPos, blockState, 0);
        super.entityInside(blockState, level, blockPos, entity);
    }

    protected int getTickRate() {
        return 20;
    }

    @Override
    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource rand) {
        this.updateState((Level)world, pos, blockstate, (Boolean)blockstate.getValue((Property)POWERED) != false ? 1 : 0);
    }

    protected void updateNeighbors(BlockState blockstate, Level world, BlockPos pos) {
        if (blockstate.getBlock() != BzBlocks.STICKY_HONEY_REDSTONE.get()) {
            return;
        }
        if (((Boolean)blockstate.getValue((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(Direction.DOWN))).booleanValue()) {
            world.blockUpdated(pos, (Block)this);
        }
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.getValue((Property)booleanproperty)).booleanValue()) continue;
            world.updateNeighborsAt(pos.relative(direction), (Block)this);
        }
    }

    protected void updateState(Level world, BlockPos pos, BlockState oldBlockstate, int oldRedstoneStrength) {
        boolean flag1;
        int newPower = this.computeRedstoneStrength(oldBlockstate, world, pos);
        boolean bl = flag1 = newPower > 0;
        if (oldRedstoneStrength != newPower) {
            BlockState newBlockstate = this.setRedstoneStrength(oldBlockstate, newPower);
            world.setBlock(pos, newBlockstate, 2);
            this.updateNeighbors(oldBlockstate, world, pos);
            world.onBlockStateChange(pos, oldBlockstate, newBlockstate);
        }
        if (flag1) {
            world.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getTickRate());
        }
    }

    public void onRemove(BlockState blockstate, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && blockstate.getBlock() != newState.getBlock()) {
            if (((Boolean)blockstate.getValue((Property)POWERED)).booleanValue()) {
                this.updateTarget(world, pos, blockstate);
            }
            super.onRemove(blockstate, world, pos, newState, false);
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        this.updateTarget(world, pos, state);
    }

    protected void updateTarget(Level world, BlockPos pos, BlockState blockstate) {
        for (Direction direction : Direction.values()) {
            if (!((Boolean)blockstate.getValue((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            BlockPos blockPos = pos.relative(direction);
            world.neighborChanged(blockPos, (Block)this, pos);
            world.updateNeighborsAtExceptFromFacing(blockPos, (Block)this, direction);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (this.computeRedstoneStrength(state, world, pos) > 0) {
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockstate.getValue((Property)POWERED)).booleanValue() && ((Boolean)blockstate.getValue((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(Direction.DOWN))).booleanValue()) {
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                if (horizontal != side) continue;
                return 1;
            }
        }
        return (Boolean)blockstate.getValue((Property)POWERED) != false && (Boolean)blockstate.getValue((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(side.getOpposite())) != false ? 1 : 0;
    }

    public int getDirectSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.getSignal(blockstate, blockAccess, pos, side);
    }

    protected BlockState setRedstoneStrength(BlockState blockstate, int strength) {
        return (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(BlockState blockstate, Level world, BlockPos pos) {
        VoxelShape voxelShape = this.getShape(blockstate, (BlockGetter)world, pos, null);
        if (voxelShape.isEmpty()) {
            return 0;
        }
        AABB axisalignedbb = voxelShape.bounds().move(pos);
        List list = world.getEntitiesOfClass(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        super.animateTick(blockState, world, position, random);
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            for (int i = 0; i == random.nextInt(2); ++i) {
                Direction randomDirection = Direction.values()[random.nextInt(Direction.values().length)];
                this.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(255.0f, 0.0f, 0.0f), 1.0f), random, world, position, blockState, randomDirection);
            }
        }
    }
}

