/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzStructures;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.worldgen.structures.OptimizedJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class GenericOptimizedStructure
extends Structure {
    public static final MapCodec<GenericOptimizedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericOptimizedStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("min_y_limit").forGetter(structure -> structure.minYLimit), (App)Codec.BOOL.fieldOf("disable_bound_checks").orElse((Object)false).forGetter(structure -> structure.disableBoundChecks), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, GenericOptimizedStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    public final Optional<Integer> biomeRadius;
    public final Optional<Integer> minYLimit;
    public final boolean disableBoundChecks;
    public final LiquidSettings liquidSettings;

    public GenericOptimizedStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> biomeRadius, Optional<Integer> minYLimit, boolean disableBoundChecks, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.biomeRadius = biomeRadius;
        this.minYLimit = minYLimit;
        this.disableBoundChecks = disableBoundChecks;
        this.liquidSettings = liquidSettings;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.chunkPos();
        int y = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos centerPos = new BlockPos(chunkpos.getMinBlockX(), y, chunkpos.getMinBlockZ());
        if (this.biomeRadius.isPresent() && !(context.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = centerPos.getY();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += GeneralUtils.getLowestLand(context.chunkGenerator(), context.randomState(), centerPos, context.heightAccessor(), true, this.projectStartToHeightmap.get() == Heightmap.Types.OCEAN_FLOOR_WG).getY();
            }
            sectionY = QuartPos.fromBlock((int)sectionY);
            for (int curChunkX = chunkpos.x - validBiomeRange; curChunkX <= chunkpos.x + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkpos.z - validBiomeRange; curChunkZ <= chunkpos.z + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.biomeSource().getNoiseBiome(QuartPos.fromSection((int)curChunkX), sectionY, QuartPos.fromSection((int)curChunkZ), context.randomState().sampler());
                    if (context.validBiome().test(biome)) continue;
                    return Optional.empty();
                }
            }
        }
        return OptimizedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, ((Registry)context.registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)this), centerPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.minYLimit, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(centerPos, pieces), this.disableBoundChecks, this.liquidSettings, this.startJigsawName);
    }

    public StructureType<?> type() {
        return (StructureType)BzStructures.GENERIC_OPTIMIZED_STRUCTURE.get();
    }
}

