/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeRegistryHolder;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.AreaFactory;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.LazyArea;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class Layer {
    private final LazyArea area;

    public Layer(AreaFactory<LazyArea> areaFactory) {
        this.area = areaFactory.make();
    }

    public Holder<Biome> sample(int x, int z) {
        int resultBiomeID = this.area.get(x, z);
        Optional biome = BiomeRegistryHolder.BIOME_REGISTRY.getHolder(resultBiomeID);
        if (biome.isEmpty()) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw (IllegalStateException)Util.pauseInIde((Throwable)new IllegalStateException("Unknown biome id: " + resultBiomeID));
            }
            ResourceKey backupBiomeKey = Biomes.OCEAN;
            Bumblezone.LOGGER.warn("Unknown biome id: ${}. Will spawn ${} instead.", (Object)resultBiomeID, (Object)backupBiomeKey.location());
            return BiomeRegistryHolder.BIOME_REGISTRY.getHolderOrThrow(backupBiomeKey);
        }
        return (Holder)biome.get();
    }
}

