/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalShieldRenderer;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CosmicCrystalRenderer
extends LivingEntityRenderer<CosmicCrystalEntity, CosmicCrystalModel> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/cosmic_crystal.png");
    private static final ResourceLocation LASER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/cosmic_crystal_laser.png");

    public CosmicCrystalRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CosmicCrystalModel(context.bakeLayer(CosmicCrystalModel.LAYER_LOCATION)), 0.7f);
        this.addLayer(new CosmicCrystalShieldRenderer((RenderLayerParent<CosmicCrystalEntity, CosmicCrystalModel>)this, context.getModelSet()));
    }

    public void render(CosmicCrystalEntity cosmicCrystalEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        this.renderLiving(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
        this.renderLaser(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
    }

    public void renderLiving(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        ((CosmicCrystalModel)this.model).attackTime = this.getAttackAnim(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.model).riding = cosmicCrystalEntity.isPassenger();
        ((CosmicCrystalModel)this.model).young = cosmicCrystalEntity.isBaby();
        float lerpedXRot = Mth.rotLerp((float)partialTick, (float)cosmicCrystalEntity.xRotO, (float)cosmicCrystalEntity.getXRot());
        float lerpedYRot = Mth.rotLerp((float)partialTick, (float)cosmicCrystalEntity.yRotO, (float)cosmicCrystalEntity.getYRot());
        float rotAxisDiff = lerpedYRot - lerpedXRot;
        float xRot = Mth.lerp((float)partialTick, (float)cosmicCrystalEntity.xRotO, (float)cosmicCrystalEntity.getXRot());
        this.setupRotations(cosmicCrystalEntity, poseStack, lerpedXRot, lerpedYRot, partialTick);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(cosmicCrystalEntity, poseStack, partialTick);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float n = 0.0f;
        float o = 0.0f;
        if (!cosmicCrystalEntity.isPassenger() && cosmicCrystalEntity.isAlive()) {
            n = cosmicCrystalEntity.walkAnimation.speed(partialTick);
            o = cosmicCrystalEntity.walkAnimation.position(partialTick);
            if (n > 1.0f) {
                n = 1.0f;
            }
        }
        float tickTimeWithPartial = this.getBob(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.model).prepareMobModel((Entity)cosmicCrystalEntity, o, n, partialTick);
        ((CosmicCrystalModel)this.model).setupAnim(cosmicCrystalEntity, o, n, tickTimeWithPartial, rotAxisDiff, xRot);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = this.isBodyVisible(cosmicCrystalEntity);
        boolean bl2 = !bl && !cosmicCrystalEntity.isInvisibleTo((Player)minecraft.player);
        boolean bl3 = minecraft.shouldEntityAppearGlowing((Entity)cosmicCrystalEntity);
        RenderType renderType = this.getRenderType(cosmicCrystalEntity, bl, bl2, bl3);
        if (renderType != null) {
            float currentHealthState;
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(renderType);
            int overlayCoords = LivingEntityRenderer.getOverlayCoords((LivingEntity)cosmicCrystalEntity, (float)this.getWhiteOverlayProgress(cosmicCrystalEntity, partialTick));
            float red = currentHealthState = Math.min(1.0f, Math.min(1.0f, cosmicCrystalEntity.getHealth() / cosmicCrystalEntity.getMaxHealth()) * 0.45f + 0.6f);
            float green = currentHealthState;
            float blue = currentHealthState;
            if (cosmicCrystalEntity.getTicksFrozen() > 0) {
                red *= 0.75f;
                green *= 0.75f;
            }
            if (cosmicCrystalEntity.isOnFire()) {
                green *= 0.75f;
                blue *= 0.75f;
            }
            for (Holder mobEffect : new HashSet(cosmicCrystalEntity.getActiveEffectsMap().keySet())) {
                String namespace;
                if (mobEffect.is(MobEffects.POISON)) {
                    red *= 0.75f;
                    blue *= 0.75f;
                    continue;
                }
                if (mobEffect.is(MobEffects.WITHER)) {
                    red *= 0.5f;
                    green *= 0.5f;
                    blue *= 0.5f;
                    continue;
                }
                if (((MobEffect)mobEffect.value()).isInstantenous() || ((MobEffect)mobEffect.value()).isBeneficial() || (namespace = ((ResourceKey)mobEffect.unwrapKey().get()).location().getNamespace()).equals("minecraft") || namespace.equals("the_bumblezone")) continue;
                red = (red + (float)GeneralUtils.getRed(((MobEffect)mobEffect.value()).getColor()) / 255.0f) / 2.0f;
                green = (green + (float)GeneralUtils.getGreen(((MobEffect)mobEffect.value()).getColor()) / 255.0f) / 2.0f;
                blue = (blue + (float)GeneralUtils.getBlue(((MobEffect)mobEffect.value()).getColor()) / 255.0f) / 2.0f;
            }
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, overlayCoords, FastColor.ARGB32.colorFromFloat((float)(bl2 ? 0.15f : 1.0f), (float)red, (float)green, (float)blue));
        }
        if (!cosmicCrystalEntity.isSpectator()) {
            for (RenderLayer renderLayer : this.layers) {
                renderLayer.render(poseStack, multiBufferSource, packedLight, (Entity)cosmicCrystalEntity, o, n, partialTick, tickTimeWithPartial, rotAxisDiff, xRot);
            }
        }
        poseStack.popPose();
    }

    protected void renderHealth(Entity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (this.entityRenderDispatcher.distanceToSqr(entity) > 100.0) {
            return;
        }
        float f = entity.getBbHeight() + 1.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, f, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float g = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int k = (int)(g * 255.0f) << 24;
        Font font = this.getFont();
        float h = (float)(-font.width((FormattedText)component)) / 2.0f;
        font.drawInBatch(component, h, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, k, packedLight);
        font.drawInBatch(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    protected void setupRotations(CosmicCrystalEntity cosmicCrystalEntity, PoseStack poseStack, float lerpedXRot, float lerpedYRot, float partialTick) {
        if (this.isShaking(cosmicCrystalEntity)) {
            lerpedXRot += (float)(Math.cos((double)cosmicCrystalEntity.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - lerpedYRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f - lerpedXRot));
        poseStack.translate(0.0f, -1.0f, 0.0f);
    }

    public void renderLaser(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (cosmicCrystalEntity.isLaserFiring()) {
            float totalTickTime = (float)cosmicCrystalEntity.tickCount + partialTick;
            float colorSpeed = -5.0f;
            long uniqueValue = cosmicCrystalEntity.getUUID().getLeastSignificantBits() % 1000000L;
            float radianColor = (totalTickTime * colorSpeed + (float)uniqueValue) % 360.0f * ((float)Math.PI / 180);
            int baseBrightness = 200;
            int colorStrength = 55;
            float redSin = Mth.sin((float)radianColor);
            float greenSin = Mth.sin((float)(radianColor + 30.0f));
            float blueSin = Mth.sin((float)(radianColor + 60.0f));
            int red = baseBrightness + (int)(redSin * (float)colorStrength);
            int green = baseBrightness + (int)(greenSin * (float)colorStrength);
            int blue = baseBrightness + (int)(blueSin * (float)colorStrength);
            float redSin2 = Mth.cos((float)radianColor);
            float greenSin2 = Mth.cos((float)(radianColor + 30.0f));
            float blueSin2 = Mth.cos((float)(radianColor + 60.0f));
            int red2 = baseBrightness + (int)(redSin2 * (float)colorStrength);
            int green2 = baseBrightness + (int)(greenSin2 * (float)colorStrength);
            int blue2 = baseBrightness + (int)(blueSin2 * (float)colorStrength);
            float eyeY = cosmicCrystalEntity.getEyeHeight();
            if (cosmicCrystalEntity.getCosmicCrystalState() == CosmicCrystalState.SWEEP_LASER || cosmicCrystalEntity.getCosmicCrystalState() == CosmicCrystalState.TRACKING_LASER) {
                eyeY = 1.0f;
            }
            poseStack.pushPose();
            Vec3 startPos = cosmicCrystalEntity.getEyePosition();
            Vec3 prevLookAngle = cosmicCrystalEntity.prevLookAngle;
            Vec3 lookAngle = cosmicCrystalEntity.getLookAngle();
            Vec3 lerpedLook = new Vec3(Mth.lerp((double)partialTick, (double)prevLookAngle.x(), (double)lookAngle.x()), Mth.lerp((double)partialTick, (double)prevLookAngle.y(), (double)lookAngle.y()), Mth.lerp((double)partialTick, (double)prevLookAngle.z(), (double)lookAngle.z()));
            Vec3 endPos = lerpedLook.scale(50.0).add(startPos);
            BlockHitResult hitResult = cosmicCrystalEntity.level().clip(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)cosmicCrystalEntity));
            if (hitResult.getType() != HitResult.Type.MISS) {
                endPos = hitResult.getLocation().subtract(lookAngle);
            }
            Vec3 vectToTarget = endPos.subtract(startPos);
            float laserLength = (float)vectToTarget.length() - 0.01f;
            vectToTarget = vectToTarget.normalize();
            float n = (float)Math.acos(vectToTarget.y);
            float o = (float)Math.atan2(vectToTarget.z, vectToTarget.x);
            poseStack.translate(lookAngle.x(), (double)eyeY + lookAngle.y(), lookAngle.z());
            poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - o) * 57.295776f));
            poseStack.mulPose(Axis.XP.rotationDegrees(n * 57.295776f));
            float q = totalTickTime * 0.05f * -1.5f;
            float v = 0.2f;
            float w2 = 0.5f;
            float z5 = Mth.sin((float)(q + 2.3561945f)) * w2;
            float x7 = Mth.cos((float)(q + 2.3561945f)) * w2;
            float z9 = Mth.cos((float)(q + 0.7853982f)) * w2;
            float z6 = Mth.sin((float)(q + 0.7853982f)) * w2;
            float x6 = Mth.cos((float)(q + 3.926991f)) * w2;
            float z8 = Mth.sin((float)(q + 3.926991f)) * w2;
            float x5 = Mth.cos((float)(q + 5.4977875f)) * w2;
            float z7 = Mth.sin((float)(q + 5.4977875f)) * w2;
            float x1 = Mth.cos((float)(q + (float)Math.PI)) * v;
            float z1 = Mth.sin((float)(q + (float)Math.PI)) * v;
            float x2 = Mth.cos((float)(q + 0.0f)) * v;
            float z2 = Mth.sin((float)(q + 0.0f)) * v;
            float x3 = Mth.cos((float)(q + 1.5707964f)) * v;
            float z3 = Mth.sin((float)(q + 1.5707964f)) * v;
            float x4 = Mth.cos((float)(q + 4.712389f)) * v;
            float z4 = Mth.sin((float)(q + 4.712389f)) * v;
            float y1 = laserLength;
            float y2 = 0.0f;
            float ux1 = 0.4999f;
            float ux2 = 0.0f;
            float uv2 = -1.0f + totalTickTime * -0.2f % 1.0f;
            float uv1 = laserLength * 2.5f + uv2;
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(BumblezoneClient.ENTITY_CUTOUT_EMISSIVE_RENDER_TYPE.apply(LASER_LOCATION));
            PoseStack.Pose pose = poseStack.last();
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x1, y1, z1, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x1, y2, z1, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x2, y2, z2, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x2, y1, z2, red2, green2, blue2, ux2, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x3, y1, z3, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x3, y2, z3, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x4, y2, z4, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x4, y1, z4, red2, green2, blue2, ux2, uv1);
            float as = 0.0f;
            if (cosmicCrystalEntity.tickCount % 4 < 2) {
                as = 0.5f;
            }
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x7, y1, z5, red2, green2, blue2, 0.5f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, z9, y1, z6, red2, green2, blue2, 1.0f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x5, y1, z7, red2, green2, blue2, 1.0f, as);
            CosmicCrystalRenderer.vertex(vertexConsumer, pose, x6, y1, z8, red2, green2, blue2, 0.5f, as);
            poseStack.popPose();
            CosmicCrystalRenderer.laserScreenShake(cosmicCrystalEntity, endPos);
        }
    }

    private static void laserScreenShake(CosmicCrystalEntity cosmicCrystalEntity, Vec3 endPos) {
        double threshold;
        double distance2;
        double distance1;
        double minDistance;
        Entity camera = Minecraft.getInstance().getCameraEntity();
        if (camera != null && (minDistance = Math.min(distance1 = cosmicCrystalEntity.position().distanceTo(camera.position()), distance2 = endPos.distanceTo(camera.position()))) <= (threshold = 10.0)) {
            double percentageToCenter = 1.0 - minDistance / threshold;
            double spinSlowdown = 0.15 + 0.3 * (1.0 - percentageToCenter * percentageToCenter);
            float intensity = (float)(0.175 * percentageToCenter * percentageToCenter * percentageToCenter);
            double currentMillisecond = (double)System.currentTimeMillis() % (360.0 * spinSlowdown);
            double degrees = currentMillisecond / spinSlowdown;
            float angle = (float)(degrees * 0.01745329238474369);
            camera.setYRot(camera.getYRot() + Mth.sin((float)angle) * intensity);
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float ux, float uz) {
        vertexConsumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(ux, uz).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(CosmicCrystalEntity cosmicCrystalEntity) {
        return SKIN;
    }

    protected boolean shouldShowName(CosmicCrystalEntity entity) {
        return false;
    }
}

