/*
 * Decompiled with CFR 0.152.
 */
package jdlenl.thaumon.block.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResearchNotesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ResearchNotesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.thaumon.canbeplaced"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        VoxelShape shape = switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)ResearchNotesBlock.box((double)4.0, (double)0.002, (double)9.0, (double)6.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[]{ResearchNotesBlock.box((double)4.25, (double)2.0, (double)9.25, (double)5.75, (double)2.5, (double)10.75), ResearchNotesBlock.box((double)4.0, (double)2.5, (double)9.0, (double)6.0, (double)3.0, (double)11.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)ResearchNotesBlock.box((double)5.0, (double)0.002, (double)4.0, (double)7.0, (double)2.0, (double)6.0), (VoxelShape[])new VoxelShape[]{ResearchNotesBlock.box((double)5.25, (double)2.0, (double)4.25, (double)6.75, (double)2.5, (double)5.75), ResearchNotesBlock.box((double)5.0, (double)2.5, (double)4.0, (double)7.0, (double)3.0, (double)6.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)ResearchNotesBlock.box((double)9.0, (double)0.002, (double)10.0, (double)11.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{ResearchNotesBlock.box((double)9.25, (double)2.0, (double)10.25, (double)10.75, (double)2.5, (double)11.75), ResearchNotesBlock.box((double)9.0, (double)2.5, (double)10.0, (double)11.0, (double)3.0, (double)12.0)});
            default -> Shapes.or((VoxelShape)ResearchNotesBlock.box((double)10.0, (double)0.002, (double)5.0, (double)12.0, (double)2.0, (double)7.0), (VoxelShape[])new VoxelShape[]{ResearchNotesBlock.box((double)10.25, (double)2.0, (double)5.25, (double)11.75, (double)2.5, (double)6.75), ResearchNotesBlock.box((double)10.0, (double)2.5, (double)5.0, (double)12.0, (double)3.0, (double)7.0)});
        };
        return shape.move(offset.x, offset.y, offset.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

