/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.client.model.IQuadTransformer;

public final class QuadColorFix {
    public static void putBulkData(VertexConsumer buffer, PoseStack.Pose pose, BakedQuad quad, int packedLight, int packedOverlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (quad.isTinted()) {
            int tintIndex = quad.getTintIndex();
            int abgr = quad.getVertices()[tintIndex * IQuadTransformer.STRIDE + IQuadTransformer.COLOR];
            red = (float)FastColor.ABGR32.red((int)abgr) / 255.0f;
            green = (float)FastColor.ABGR32.green((int)abgr) / 255.0f;
            blue = (float)FastColor.ABGR32.blue((int)abgr) / 255.0f;
            alpha = (float)FastColor.ABGR32.alpha((int)abgr) / 255.0f;
        }
        buffer.putBulkData(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }
}

