/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.swedz.tesseract.neoforge.api.Assert;

public final class ModelHelper {
    public static LinkedHashMap<String, Material> gatherTextures(ResourceLocation atlas, JsonObject json, String name) {
        Assert.notNull(name);
        if (json == null || !json.has(name)) {
            return Maps.newLinkedHashMap();
        }
        LinkedHashMap textures = Maps.newLinkedHashMap();
        for (Map.Entry entry : json.getAsJsonObject(name).entrySet()) {
            textures.put((String)entry.getKey(), new Material(atlas, ResourceLocation.parse((String)((JsonElement)entry.getValue()).getAsString())));
        }
        return textures;
    }

    public static LinkedHashMap<String, Material> gatherTextures(JsonObject json, String name) {
        return ModelHelper.gatherTextures(InventoryMenu.BLOCK_ATLAS, json, name);
    }

    public static List<Material> gatherLayerTextures(ResourceLocation atlas, JsonObject json, String name) {
        Assert.notNull(name);
        if (json == null || !json.has(name)) {
            return List.of();
        }
        json = json.getAsJsonObject(name);
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        while (json.has("layer" + index)) {
            builder.add((Object)new Material(atlas, ResourceLocation.parse((String)json.get("layer" + index).getAsString())));
            ++index;
        }
        return builder.build();
    }

    public static List<Material> gatherLayerTextures(JsonObject json, String name) {
        return ModelHelper.gatherLayerTextures(InventoryMenu.BLOCK_ATLAS, json, name);
    }

    public static List<Material> gatherTextures(IGeometryBakingContext context) {
        Assert.notNull(context);
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        while (context.hasMaterial("layer" + index)) {
            builder.add((Object)context.getMaterial("layer" + index));
            ++index;
        }
        return builder.build();
    }
}

