/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.powerless;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.BasicMultiblockMachineBlockEntity;

public class PowerlessMultiblockMachineBlockEntity
extends BasicMultiblockMachineBlockEntity
implements CrafterComponentHolder {
    protected final MachineRecipeType recipeType;
    protected final int baseRecipeEU;
    protected final CrafterComponent crafter;
    protected final RedstoneControlComponent redstoneControl;
    protected OperatingState operatingState = OperatingState.NOT_MATCHED;

    public PowerlessMultiblockMachineBlockEntity(BEP bep, MachineGuiParameters guiParams, ShapeTemplate shape, MachineRecipeType recipeType, int baseRecipeEU, boolean hasRedstoneControl) {
        super(bep, guiParams, new ShapeTemplate[]{shape});
        this.recipeType = recipeType;
        this.baseRecipeEU = baseRecipeEU;
        this.crafter = new CrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)this.inventory, (CrafterComponent.Behavior)new Behavior());
        this.redstoneControl = hasRedstoneControl ? new RedstoneControlComponent() : null;
        this.registerComponents(new MachineComponent[]{this.crafter, this.isActive});
        if (hasRedstoneControl) {
            this.registerComponents(new MachineComponent[]{this.redstoneControl});
            this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        }
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new ReiSlotLocking((arg_0, arg_1) -> ((CrafterComponent)this.crafter).lockRecipe(arg_0, arg_1), () -> this.operatingState != OperatingState.NOT_MATCHED);
        this.registerGuiComponent(guiComponentServerArray);
        this.registerGuiComponent(new GuiComponentServer[]{new ModularMultiblockGui(80, content -> {
            boolean shapeValid = this.isShapeValid();
            boolean active = this.isActive.isActive;
            content.add((Component)(shapeValid ? MIText.MultiblockShapeValid : MIText.MultiblockShapeInvalid).text(), shapeValid ? 0xFFFFFF : 0xFF0000);
            if (shapeValid) {
                content.add((Component)MIText.MultiblockStatusActive.text());
                if (this.crafter != null && this.crafter.hasActiveRecipe()) {
                    content.add((Component)MIText.Progress.text(new Object[]{String.format("%.1f", Float.valueOf(this.crafter.getProgress() * 100.0f)) + " %"}));
                }
            }
        })});
    }

    @Override
    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        data.isActive = this.isActive.isActive;
        return data;
    }

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        this.operatingState = OperatingState.NOT_MATCHED;
        if (shapeMatcher.isMatchSuccessful()) {
            this.operatingState = OperatingState.TRYING_TO_RESUME;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        boolean active = false;
        if (this.operatingState == OperatingState.TRYING_TO_RESUME && this.crafter.tryContinueRecipe()) {
            this.operatingState = OperatingState.NORMAL_OPERATION;
        }
        if (this.operatingState == OperatingState.NORMAL_OPERATION) {
            if (this.crafter.tickRecipe()) {
                active = true;
            }
        } else {
            this.crafter.decreaseEfficiencyTicks();
        }
        this.updateActive(active);
    }

    public static enum OperatingState {
        NOT_MATCHED,
        TRYING_TO_RESUME,
        NORMAL_OPERATION;

    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        public boolean isEnabled() {
            return PowerlessMultiblockMachineBlockEntity.this.redstoneControl == null || PowerlessMultiblockMachineBlockEntity.this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)PowerlessMultiblockMachineBlockEntity.this);
        }

        public long consumeEu(long max, Simulation simulation) {
            return max;
        }

        public MachineRecipeType recipeType() {
            return PowerlessMultiblockMachineBlockEntity.this.recipeType;
        }

        public long getBaseRecipeEu() {
            return PowerlessMultiblockMachineBlockEntity.this.baseRecipeEU;
        }

        public long getMaxRecipeEu() {
            return this.getBaseRecipeEu();
        }

        public ServerLevel getCrafterWorld() {
            return (ServerLevel)PowerlessMultiblockMachineBlockEntity.this.level;
        }

        public UUID getOwnerUuid() {
            return PowerlessMultiblockMachineBlockEntity.this.placedBy.placerId;
        }
    }
}

