/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.powerless;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;

public class PowerlessMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
CrafterComponentHolder {
    protected final MachineRecipeType recipeType;
    protected final int baseRecipeEU;
    protected final MachineInventoryComponent inventory;
    protected final CrafterComponent crafter;
    protected final IsActiveComponent isActive;
    protected final RedstoneControlComponent redstoneControl;

    public PowerlessMachineBlockEntity(BEP bep, MachineGuiParameters guiParams, ProgressBar.Params progressBarParams, MachineInventoryComponent inventory, MachineRecipeType recipeType, int baseRecipeEU, boolean hasRedstoneControl) {
        super(bep, guiParams, new OrientationComponent.Params(true, inventory.itemOutputCount > 0, inventory.fluidOutputCount > 0));
        this.recipeType = recipeType;
        this.baseRecipeEU = baseRecipeEU;
        this.inventory = inventory;
        this.crafter = new CrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)inventory, (CrafterComponent.Behavior)new Behavior());
        this.isActive = new IsActiveComponent();
        this.redstoneControl = hasRedstoneControl ? new RedstoneControlComponent() : null;
        this.registerComponents(new MachineComponent[]{inventory, this.crafter, this.isActive});
        if (hasRedstoneControl) {
            this.registerComponents(new MachineComponent[]{this.redstoneControl});
            this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        }
        this.registerGuiComponent(new GuiComponentServer[]{new AutoExtract(this.orientation)});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new ProgressBar(progressBarParams, () -> ((CrafterComponent)this.crafter).getProgress());
        this.registerGuiComponent(guiComponentServerArray);
        GuiComponentServer[] guiComponentServerArray2 = new GuiComponentServer[1];
        guiComponentServerArray2[0] = new ReiSlotLocking((arg_0, arg_1) -> ((CrafterComponent)this.crafter).lockRecipe(arg_0, arg_1), () -> true);
        this.registerGuiComponent(guiComponentServerArray2);
    }

    public MIInventory getInventory() {
        return this.inventory.inventory;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        data.isActive = this.isActive.isActive;
        return data;
    }

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean active = this.crafter.tickRecipe();
        this.isActive.updateActive(active, (MachineBlockEntity)this);
        if (this.orientation.extractItems) {
            this.inventory.inventory.autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        if (this.orientation.extractFluids) {
            this.inventory.inventory.autoExtractFluids(this.level, this.worldPosition, this.orientation.outputDirection);
        }
        this.setChanged();
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        public boolean isEnabled() {
            return PowerlessMachineBlockEntity.this.redstoneControl == null || PowerlessMachineBlockEntity.this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)PowerlessMachineBlockEntity.this);
        }

        public long consumeEu(long max, Simulation simulation) {
            return max;
        }

        public MachineRecipeType recipeType() {
            return PowerlessMachineBlockEntity.this.recipeType;
        }

        public long getBaseRecipeEu() {
            return PowerlessMachineBlockEntity.this.baseRecipeEU;
        }

        public long getMaxRecipeEu() {
            return this.getBaseRecipeEu();
        }

        public ServerLevel getCrafterWorld() {
            return (ServerLevel)PowerlessMachineBlockEntity.this.level;
        }

        public UUID getOwnerUuid() {
            return PowerlessMachineBlockEntity.this.placedBy.placerId;
        }
    }
}

