/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.helper;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccess;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;

public final class CommonGuiComponents {
    public static ShapeSelection rangedShapeSelection(final MultiblockMachineBlockEntity machine, final ActiveShapeComponent activeShape, List<Component> translations, boolean useArrows) {
        return new ShapeSelection(new ShapeSelection.Behavior(){

            public void handleClick(int line, int delta) {
                activeShape.incrementShape(machine, delta);
            }

            public int getCurrentIndex(int line) {
                return activeShape.getActiveShapeIndex();
            }
        }, new ShapeSelection.LineInfo[]{new ShapeSelection.LineInfo(translations, useArrows)});
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, ModularCrafterAccess crafter, Supplier<Long> baseEuSupplier, IsActiveComponent isActive, int y, int height) {
        return new ModularMultiblockGui(y, height, content -> {
            boolean shapeValid = machine.isShapeValid();
            boolean active = isActive.isActive;
            content.add((Component)(shapeValid ? MIText.MultiblockShapeValid : MIText.MultiblockShapeInvalid).text(), shapeValid ? 0xFFFFFF : 0xFF0000);
            if (shapeValid) {
                content.add((Component)MIText.MultiblockStatusActive.text());
                if (crafter != null && crafter.hasActiveRecipe()) {
                    content.add((Component)MIText.Progress.text(new Object[]{String.format("%.1f", Float.valueOf(crafter.getProgress() * 100.0f)) + " %"}));
                    if (crafter.getEfficiencyTicks() != 0 || crafter.getMaxEfficiencyTicks() != 0) {
                        content.add((Component)MIText.EfficiencyTicks.text(new Object[]{crafter.getEfficiencyTicks(), crafter.getMaxEfficiencyTicks()}));
                    }
                    content.add((Component)MIText.BaseEuRecipe.text(new Object[]{TextHelper.getEuTextTick((long)((Long)baseEuSupplier.get()))}));
                    content.add((Component)MIText.CurrentEuRecipe.text(new Object[]{TextHelper.getEuTextTick((long)crafter.getCurrentRecipeEu())}));
                }
            }
        });
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, ModularCrafterAccess crafter, Supplier<Long> baseEuSupplier, IsActiveComponent isActive) {
        return CommonGuiComponents.standardMultiblockScreen(machine, crafter, baseEuSupplier, isActive, 0, 80);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, ModularCrafterAccess crafter, IsActiveComponent isActive, int y, int height) {
        return CommonGuiComponents.standardMultiblockScreen(machine, crafter, () -> ((ModularCrafterAccess)crafter).getBaseRecipeEu(), isActive, y, height);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, ModularCrafterAccess crafter, IsActiveComponent isActive, int height) {
        return CommonGuiComponents.standardMultiblockScreen(machine, crafter, () -> ((ModularCrafterAccess)crafter).getBaseRecipeEu(), isActive, 0, height);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, ModularCrafterAccess crafter, IsActiveComponent isActive) {
        return CommonGuiComponents.standardMultiblockScreen(machine, crafter, isActive, 80);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, IsActiveComponent isActive, int y, int height) {
        return CommonGuiComponents.standardMultiblockScreen(machine, null, null, isActive, y, height);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, IsActiveComponent isActive, int height) {
        return CommonGuiComponents.standardMultiblockScreen(machine, null, null, isActive, 0, height);
    }

    public static ModularMultiblockGui standardMultiblockScreen(MultiblockMachineBlockEntity machine, IsActiveComponent isActive) {
        return CommonGuiComponents.standardMultiblockScreen(machine, isActive, 80);
    }
}

