/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel;

import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanel;
import net.swedz.tesseract.neoforge.compat.mi.network.packet.UpdateMachineConfigurationPanelPacket;

public final class ConfigurationPanelClient
extends GuiComponentClient<ConfigurationPanel.Params, ConfigurationPanel.Data> {
    private Renderer renderer;

    public ConfigurationPanelClient(ConfigurationPanel.Params params, ConfigurationPanel.Data data) {
        super((Object)params, (Object)data);
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        int maxWidth = 1;
        for (ConfigurationPanel.LineInfo line : ((ConfigurationPanel.Params)this.params).lines()) {
            for (Component tooltip : line.translations()) {
                maxWidth = Math.max(maxWidth, Minecraft.getInstance().font.width((FormattedText)tooltip));
            }
        }
        this.renderer = new Renderer(maxWidth);
        return this.renderer;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    final class Renderer
    implements ClientComponentRenderer {
        boolean isPanelOpen = false;
        private final int btnSize = 12;
        private final int borderSize = 3;
        private final int outerPadding = 5;
        private final int innerPadding = 5;
        private final int textMaxWidth;
        private final int panelWidth;

        private Renderer(int textMaxWidth) {
            this.textMaxWidth = textMaxWidth;
            this.panelWidth = 25 + textMaxWidth + 5 + 12 + 5;
        }

        private static int getVerticalPos(int lineId) {
            return 46 + 16 * lineId;
        }

        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            for (int i = 0; i < ((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).lines().size(); ++i) {
                int iCopy = i;
                ConfigurationPanel.LineInfo line = ((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).lines().get(i);
                int baseU = line.useArrows() ? 174 : 150;
                int v = 58;
                container.addButton(-this.panelWidth + 3 + 5, Renderer.getVerticalPos(i), 12, 12, syncId -> new UpdateMachineConfigurationPanelPacket((int)syncId, iCopy, true).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (((ConfigurationPanel.Data)ConfigurationPanelClient.this.data).selectedIndexes().get(iCopy) == 0) {
                        screen.blitButtonNoHighlight((Button)button, guiGraphics, baseU, v + 12);
                    } else {
                        screen.blitButtonSmall((Button)button, guiGraphics, baseU, v);
                    }
                }, () -> this.isPanelOpen);
                container.addButton(-17, Renderer.getVerticalPos(i), 12, 12, syncId -> new UpdateMachineConfigurationPanelPacket((int)syncId, iCopy, false).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (((ConfigurationPanel.Data)ConfigurationPanelClient.this.data).selectedIndexes().get(iCopy) == line.numValues() - 1) {
                        screen.blitButtonNoHighlight((Button)button, guiGraphics, baseU + 12, v + 12);
                    } else {
                        screen.blitButtonSmall((Button)button, guiGraphics, baseU + 12, v);
                    }
                }, () -> this.isPanelOpen);
            }
            container.addButton(-24, 17, 20, 20, syncId -> {
                this.isPanelOpen = !this.isPanelOpen;
            }, () -> List.of(((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).title(), ((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).description()), (screen, button, guiGraphics, mouseX, mouseY, delta) -> screen.blitButton((Button)button, guiGraphics, 138, 38));
        }

        public void renderBackground(GuiGraphics guiGraphics, int leftPos, int topPos) {
            Rectangle box = this.getBox(leftPos, topPos);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), 0, 0, box.w(), box.h() - 4);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, 0, 252, box.w(), 4);
            if (this.isPanelOpen) {
                RenderSystem.disableDepthTest();
                for (int index = 0; index < ((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).lines().size(); ++index) {
                    ConfigurationPanel.LineInfo line = ((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).lines().get(index);
                    Component tooltip = line.translations().get(((ConfigurationPanel.Data)ConfigurationPanelClient.this.data).selectedIndexes().get(index));
                    int width = Minecraft.getInstance().font.width((FormattedText)tooltip);
                    guiGraphics.drawString(Minecraft.getInstance().font, tooltip, box.x() + 3 + 5 + 12 + 5 + (this.textMaxWidth - width) / 2, topPos + Renderer.getVerticalPos(index) + 2, 0x404040, false);
                }
                RenderSystem.enableDepthTest();
            }
        }

        public Rectangle getBox(int leftPos, int topPos) {
            if (this.isPanelOpen) {
                int topOffset = 10;
                return new Rectangle(leftPos - this.panelWidth, topPos + topOffset, this.panelWidth, Renderer.getVerticalPos(((ConfigurationPanel.Params)ConfigurationPanelClient.this.params).lines().size() - 1) - topOffset + 12 + 5 + 3);
            }
            return new Rectangle(leftPos - 31, topPos + 10, 31, 34);
        }

        public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
            rectangles.add(this.getBox(leftPos, topPos));
        }
    }
}

