/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.part;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.swedz.tesseract.neoforge.helper.TagHelper;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.MaterialRegistry;
import net.swedz.tesseract.neoforge.material.builtin.property.MaterialProperties;
import net.swedz.tesseract.neoforge.material.part.MaterialPartAction;
import net.swedz.tesseract.neoforge.material.part.MaterialPartBlockBlockFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartBlockFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartBlockItemFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartItemFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartRegister;
import net.swedz.tesseract.neoforge.material.part.MaterialPartRegisterContext;
import net.swedz.tesseract.neoforge.material.part.MaterialPartStringFormatter;
import net.swedz.tesseract.neoforge.material.part.RegisteredMaterialPart;
import net.swedz.tesseract.neoforge.material.property.MaterialProperty;
import net.swedz.tesseract.neoforge.material.property.MaterialPropertyHolder;
import net.swedz.tesseract.neoforge.material.property.MaterialPropertyMap;
import net.swedz.tesseract.neoforge.registry.AccessibleBlockLootSubProvider;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class MaterialPart
implements MaterialPropertyHolder.Mutable {
    private static final MaterialPartRegister DEFAULT_REGISTER = context -> {
        RegisteredMaterialPart registered;
        if (context.part().isBlock()) {
            BlockWithItemHolder<Block, BlockItem> block = new BlockWithItemHolder<Block, BlockItem>(context.id(), context.englishName(), context.registry().blockRegistry(), p -> context.blockFactory().createBlock(context, (BlockBehaviour.Properties)p), context.registry().itemRegistry(), (b, p) -> context.blockFactory().createItem(context, (Block)b, (Item.Properties)p));
            registered = RegisteredMaterialPart.existingBlock(block);
            context.register(block);
        } else {
            ItemHolder<Item> item = new ItemHolder<Item>(context.id(), context.englishName(), context.registry().itemRegistry(), p -> context.itemFactory().create(context, (Item.Properties)p));
            registered = RegisteredMaterialPart.existingItem(context.get(MaterialProperties.ITEM_REFERENCE).format(context.registry().modId(), context.material(), context.part()), item);
            context.register(item);
        }
        return registered;
    };
    private final ResourceLocation id;
    private final String englishName;
    private boolean isBlock = false;
    private MaterialPartStringFormatter idFormatter;
    private MaterialPartStringFormatter englishNameFormatter;
    private MaterialPartBlockFactory blockFactory = MaterialPartBlockFactory.of((c, bp) -> new Block(bp), (c, b, ip) -> new BlockItem(b, ip));
    private MaterialPartItemFactory itemFactory = (c, p) -> new Item(p);
    private final List<MaterialPartAction<ItemHolder<? extends Item>>> itemActions = Lists.newArrayList();
    private final List<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockActions = Lists.newArrayList();
    private final MaterialPropertyMap propertyOverrides = new MaterialPropertyMap();
    private final List<MaterialPartAction<ItemHolder<? extends Item>>> itemAfterActions = Lists.newArrayList();
    private final List<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockAfterActions = Lists.newArrayList();
    private MaterialPartRegister register = DEFAULT_REGISTER;

    public MaterialPart(ResourceLocation id, String englishName) {
        this.id = id;
        this.englishName = englishName;
        this.idFormatter = (arg_0, arg_1) -> MaterialPart.lambda$new$7("%s_%s", arg_0, arg_1);
        this.englishNameFormatter = (arg_0, arg_1) -> MaterialPart.lambda$new$8("%s %s", arg_0, arg_1);
    }

    private MaterialPart copy(MaterialPartFactory creator) {
        MaterialPart copy = creator.create(this.id, this.englishName);
        copy.isBlock = this.isBlock;
        copy.idFormatter = this.idFormatter;
        copy.englishNameFormatter = this.englishNameFormatter;
        copy.itemActions.addAll(this.itemActions);
        copy.blockActions.addAll(this.blockActions);
        copy.propertyOverrides.putAll(this.propertyOverrides);
        copy.itemAfterActions.addAll(this.itemAfterActions);
        copy.blockAfterActions.addAll(this.blockAfterActions);
        copy.register = this.register;
        return copy;
    }

    public MaterialPart copy() {
        return this.copy(MaterialPart::new);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String englishName() {
        return this.englishName;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public MaterialPart asBlock() {
        MaterialPart copy = this.copy();
        copy.isBlock = true;
        return copy;
    }

    public MaterialPart formatting(MaterialPartStringFormatter idFormatter, MaterialPartStringFormatter englishNameFormatter) {
        MaterialPart copy = this.copy();
        copy.idFormatter = idFormatter;
        copy.englishNameFormatter = englishNameFormatter;
        return copy;
    }

    public MaterialPart formattingDefault() {
        return this.formatting((arg_0, arg_1) -> MaterialPart.lambda$formattingDefault$9("%s_%s", arg_0, arg_1), (arg_0, arg_1) -> MaterialPart.lambda$formattingDefault$10("%s %s", arg_0, arg_1));
    }

    public MaterialPart formattingMaterialOnly(MaterialPartStringFormatter.OnlyMaterial idFormatter, MaterialPartStringFormatter.OnlyMaterial englishNameFormatter) {
        return this.formatting(idFormatter, englishNameFormatter);
    }

    public MaterialPart formattingMaterialOnly() {
        return this.formattingMaterialOnly(m -> m, m -> m);
    }

    public MaterialPart formattingRaw(String id, String englishName) {
        return this.formatting((m, p) -> id, (m, p) -> englishName);
    }

    public String formatId(Material material) {
        return this.idFormatter.format(material.id().getPath(), this.id().getPath());
    }

    public String formatEnglishName(Material material) {
        return this.englishNameFormatter.format(material.englishName(), this.englishName());
    }

    public MaterialPart blockFactory(MaterialPartBlockFactory blockFactory) {
        MaterialPart copy = this.copy();
        copy.blockFactory = blockFactory;
        return copy;
    }

    public MaterialPart blockFactory(MaterialPartBlockBlockFactory block, MaterialPartBlockItemFactory item) {
        return this.blockFactory(MaterialPartBlockFactory.of(block, item));
    }

    public MaterialPart itemFactory(MaterialPartItemFactory itemFactory) {
        MaterialPart copy = this.copy();
        copy.itemFactory = itemFactory;
        return copy;
    }

    public MaterialPart item(MaterialPartAction<ItemHolder<? extends Item>> action) {
        MaterialPart copy = this.copy();
        copy.itemActions.add(action);
        return copy;
    }

    public MaterialPart itemOn(String modId, MaterialPartAction<ItemHolder<? extends Item>> action) {
        return this.item((c, h) -> {
            if (h.identifier().modId().equals(modId)) {
                action.apply(c, (ItemHolder<? extends Item>)h);
            }
        });
    }

    public MaterialPart itemProperty(Consumer<Item.Properties> action) {
        return this.item((c, h) -> h.withProperties(action));
    }

    public MaterialPart itemTag(Collection<TagKey<Item>> tags) {
        return this.item((c, h) -> h.tag(tags));
    }

    public MaterialPart itemTag(TagKey<Item> ... tags) {
        return this.itemTag(Arrays.asList(tags));
    }

    public MaterialPart itemModel(Function<ItemHolder<? extends Item>, Consumer<ItemModelProvider>> modelProvider) {
        return this.item((c, h) -> h.withModel(modelProvider::apply));
    }

    public MaterialPart itemModelBuilder(Function<ItemHolder<? extends Item>, Consumer<ItemModelBuilder>> modelBuilder) {
        return this.item((c, h) -> h.withModelBuilder(modelBuilder::apply));
    }

    public MaterialPart block(MaterialPartAction<BlockWithItemHolder<Block, BlockItem>> action) {
        MaterialPart copy = this.asBlock();
        copy.blockActions.add(action);
        return copy;
    }

    public MaterialPart blockOn(String modId, MaterialPartAction<BlockWithItemHolder<Block, BlockItem>> action) {
        return this.block((c, h) -> {
            if (h.identifier().modId().equals(modId)) {
                action.apply(c, (BlockWithItemHolder<Block, BlockItem>)h);
            }
        });
    }

    public MaterialPart blockProperty(Consumer<BlockBehaviour.Properties> action) {
        return this.block((c, h) -> h.withProperties(action));
    }

    public MaterialPart blockTag(Collection<TagKey<Block>> tags) {
        return this.block((c, h) -> h.tag(tags));
    }

    public MaterialPart blockTag(TagKey<Block> ... tag) {
        return this.blockTag(Arrays.asList(tag));
    }

    public MaterialPart blockModel(Function<BlockHolder<Block>, Consumer<BlockStateProvider>> modelBuilder) {
        return this.block((c, h) -> h.withModel(modelBuilder));
    }

    public MaterialPart blockLoot(Function<BlockHolder<Block>, Function<AccessibleBlockLootSubProvider, LootTable.Builder>> lootBuilder) {
        return this.block((c, h) -> h.withLootTable(lootBuilder));
    }

    public MaterialPart itemAndBlockTag(Collection<TagKey<Item>> tags) {
        MaterialPart copy = this.itemTag(tags);
        copy = copy.blockTag(tags.stream().map(t -> TagHelper.convert(t, BuiltInRegistries.BLOCK)).toList());
        return copy;
    }

    public MaterialPart itemAndBlockTag(TagKey<Item> ... tags) {
        return this.itemAndBlockTag(Arrays.asList(tags));
    }

    public MaterialPropertyMap properties() {
        return this.propertyOverrides.copy();
    }

    @Override
    public <T> boolean has(MaterialProperty<T> property) {
        return this.propertyOverrides.has(property);
    }

    @Override
    public <T> MaterialPart set(MaterialProperty<T> property, T value) {
        MaterialPart copy = this.copy();
        copy.propertyOverrides.set((MaterialProperty)property, (Object)value);
        return copy;
    }

    @Override
    public <T> MaterialPart setOptional(MaterialProperty<Optional<T>> property, T value) {
        MaterialPart copy = this.copy();
        copy.propertyOverrides.setOptional((MaterialProperty)property, (Object)value);
        return copy;
    }

    @Override
    public <T> T get(MaterialProperty<T> property) {
        return this.propertyOverrides.get(property);
    }

    public MaterialPart itemAfter(MaterialPartAction<ItemHolder<? extends Item>> action) {
        MaterialPart copy = this.copy();
        copy.itemAfterActions.add(action);
        return copy;
    }

    public MaterialPart blockAfter(MaterialPartAction<BlockWithItemHolder<Block, BlockItem>> action) {
        MaterialPart copy = this.asBlock();
        copy.blockAfterActions.add(action);
        return copy;
    }

    public MaterialPart withRegister(MaterialPartRegister register) {
        MaterialPart copy = this.copy();
        copy.register = register;
        return copy;
    }

    public MaterialPart withRegisterDefault() {
        return this.withRegister(DEFAULT_REGISTER);
    }

    public RegisteredMaterialPart register(MaterialRegistry registry, Material material) {
        ResourceLocation id = registry.id(this.formatId(material));
        String englishName = this.formatEnglishName(material);
        MaterialPartRegisterContext context = new MaterialPartRegisterContext(id, englishName, registry, material, this, this.blockFactory, this.itemFactory, this.itemActions, this.blockActions, this.itemAfterActions, this.blockAfterActions);
        return this.register.register(context);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        MaterialPart other;
        return obj instanceof MaterialPart && this.id.equals((Object)(other = (MaterialPart)obj).id());
    }

    private static /* synthetic */ String lambda$formattingDefault$10(String rec$, Object xva$0, Object xva$1) {
        return "%s %s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$formattingDefault$9(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$new$8(String rec$, Object xva$0, Object xva$1) {
        return "%s %s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$new$7(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }
}

