/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.guigraphics;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.api.Assert;
import org.joml.Matrix4f;

public final class GuiGraphicsBatch {
    private final Matrix4f pose;
    private final BufferBuilder buffer;
    private boolean open = true;

    private GuiGraphicsBatch(Matrix4f pose, BufferBuilder buffer) {
        this.pose = pose;
        this.buffer = buffer;
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format, Consumer<ShaderInstance> extraSetup) {
        RenderSystem.setShader(shader);
        RenderSystem.enableBlend();
        if (extraSetup != null) {
            extraSetup.accept(shader.get());
        }
        Matrix4f pose = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(mode, format);
        return new GuiGraphicsBatch(pose, buffer);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format) {
        return GuiGraphicsBatch.start(graphics, shader, mode, format, null);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation[] textures, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format, Consumer<ShaderInstance> extraSetup) {
        for (int i = 0; i < textures.length; ++i) {
            RenderSystem.setShaderTexture((int)i, (ResourceLocation)textures[i]);
        }
        return GuiGraphicsBatch.start(graphics, shader, mode, format, extraSetup);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation[] textures, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format) {
        return GuiGraphicsBatch.start(graphics, textures, shader, mode, format, null);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation texture, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format, Consumer<ShaderInstance> extraSetup) {
        return GuiGraphicsBatch.start(graphics, new ResourceLocation[]{texture}, shader, mode, format, extraSetup);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation texture, Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format) {
        return GuiGraphicsBatch.start(graphics, texture, shader, mode, format, null);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation[] textures) {
        return GuiGraphicsBatch.start(graphics, textures, GameRenderer::getPositionTexColorShader, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, null);
    }

    public static GuiGraphicsBatch start(GuiGraphics graphics, ResourceLocation texture) {
        return GuiGraphicsBatch.start(graphics, new ResourceLocation[]{texture});
    }

    public Matrix4f pose() {
        return this.pose;
    }

    public BufferBuilder buffer() {
        return this.buffer;
    }

    public void end() {
        Assert.that(this.open, "Batch is no longer open");
        this.open = false;
        BufferUploader.drawWithShader((MeshData)this.buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

