/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.ModFileScanData;

public final class AnnotationDataHelper {
    public static <E extends Enum<E>> E getEnumOrDefault(ModFileScanData.AnnotationData annotationData, Class<E> enumClass, String key, E defaultValue) {
        ModAnnotation.EnumHolder defaultHolder = new ModAnnotation.EnumHolder(null, defaultValue.name());
        ModAnnotation.EnumHolder holder = annotationData.annotationData().getOrDefault(key, defaultHolder);
        return Enum.valueOf(enumClass, holder.value());
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumSet<E> getEnumSetOrDefault(ModFileScanData.AnnotationData annotationData, Class<E> enumClass, String key, E ... defaultValues) {
        Object data = annotationData.annotationData().get(key);
        if (data == null) {
            EnumSet<E> set = EnumSet.noneOf(enumClass);
            set.addAll(Arrays.asList(defaultValues));
            return set;
        }
        return ((List)data).stream().map(holder -> Enum.valueOf(enumClass, holder.value())).collect(Collectors.toCollection(() -> EnumSet.noneOf(enumClass)));
    }
}

