/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.matcher;

import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class SameCableTierShapeMatcher
extends ShapeMatcher {
    protected final Consumer<Boolean> mismatchingHatchesCallback;

    public SameCableTierShapeMatcher(Level level, BlockPos controllerPos, Direction controllerDirection, ShapeTemplate template, Consumer<Boolean> mismatchingHatchesCallback) {
        super(level, controllerPos, controllerDirection, template);
        this.mismatchingHatchesCallback = mismatchingHatchesCallback;
    }

    protected boolean checkRematch(Level world) {
        boolean hasMismatchingHatches = false;
        HashSet tiers = Sets.newHashSet();
        for (HatchBlockEntity hatch : this.getMatchedHatches()) {
            if (!(hatch instanceof EnergyHatch)) continue;
            EnergyHatch energyHatch = (EnergyHatch)hatch;
            tiers.add(energyHatch.getCableTier());
            if (tiers.size() <= 1) continue;
            hasMismatchingHatches = true;
            break;
        }
        this.mismatchingHatchesCallback.accept(hasMismatchingHatches);
        return !hasMismatchingHatches;
    }
}

