/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public record ConfigNoise(DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ, double scale) implements DensityFunction
{
    public static MapCodec<ConfigNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("option").forGetter(df -> ""), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(ConfigNoise::noise), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ConfigNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ConfigNoise::shiftZ)).apply((Applicative)instance, ConfigNoise::new));
    public static KeyDispatchDataCodec<ConfigNoise> CODEC_HOLDER = KeyDispatchDataCodec.of(DATA_CODEC);

    public ConfigNoise(String option, DensityFunction.NoiseHolder noise, DensityFunction shiftX, DensityFunction shiftZ) {
        this(noise, shiftX, shiftZ, ConfigHandler.getConfig().getValue(option));
    }

    public double compute(@NotNull DensityFunction.FunctionContext context) {
        return this.noise.getValue((double)context.blockX() * this.scale + this.shiftX.compute(context), 0.0, (double)context.blockZ() * this.scale + this.shiftZ.compute(context));
    }

    public void fillArray(double @NotNull [] doubles, DensityFunction.ContextProvider contextProvider) {
        contextProvider.fillAllDirectly(doubles, (DensityFunction)this);
    }

    @NotNull
    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ConfigNoise(visitor.visitNoise(this.noise), this.shiftX, this.shiftZ, this.scale));
    }

    public double minValue() {
        return -this.maxValue();
    }

    public double maxValue() {
        return this.noise.maxValue();
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

