/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.mixin;

import com.google.common.base.Suppliers;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseBasedChunkGenerator.class})
public class NoiseBasedChunkGeneratorMixin {
    @Shadow
    @Final
    @Mutable
    private Supplier<Aquifer.FluidPicker> globalFluidPicker;

    @Inject(method={"<init>(Lnet/minecraft/world/level/biome/BiomeSource;Lnet/minecraft/core/Holder;)V"}, at={@At(value="RETURN")})
    private void tectonic$fixLavaLevel(BiomeSource source, Holder<NoiseGeneratorSettings> settings, CallbackInfo ci) {
        if (Tectonic.isEnabled() && settings.unwrapKey().map(key -> key.location().getPath().equals("overworld")).orElse(false).booleanValue()) {
            this.globalFluidPicker = Suppliers.memoize(() -> {
                int lavaLevel = ConfigHandler.getState().globalTerrain.heightLimits.minY + 10;
                Aquifer.FluidStatus lavaStatus = new Aquifer.FluidStatus(lavaLevel, Blocks.LAVA.defaultBlockState());
                int seaLevel = ((NoiseGeneratorSettings)settings.value()).seaLevel();
                Aquifer.FluidStatus seaStatus = new Aquifer.FluidStatus(seaLevel, ((NoiseGeneratorSettings)settings.value()).defaultFluid());
                Aquifer.FluidStatus disabledStatus = new Aquifer.FluidStatus(DimensionType.MIN_Y * 2, Blocks.AIR.defaultBlockState());
                return (j, k, l) -> {
                    if (k < Math.min(lavaLevel, seaLevel)) {
                        return lavaStatus;
                    }
                    return seaStatus;
                };
            });
        }
    }
}

