/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.util;

import com.google.common.base.Supplier;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.cache.CachedFluidStorageState;
import net.natte.tankstorage.cache.ClientTankCache;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.item.TankFunctionality;
import net.natte.tankstorage.item.TankItem;
import net.natte.tankstorage.item.TankLinkItem;
import net.natte.tankstorage.state.TankFluidStorageState;
import net.natte.tankstorage.state.TankPersistentState;
import net.natte.tankstorage.state.TankStateManager;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankFluidHandler;
import net.natte.tankstorage.storage.TankInteractionMode;
import net.natte.tankstorage.storage.TankOptions;
import net.natte.tankstorage.util.LargeFluidSlotData;
import net.natte.tankstorage.util.Texts;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static Supplier<Boolean> isShiftDown = () -> false;
    public static final ThreadLocal<Boolean> isClient = ThreadLocal.withInitial(() -> false);

    public static ResourceLocation ID(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"tankstorage", (String)id);
    }

    @Nullable
    public static TankFluidStorageState getOrCreateFluidStorage(ItemStack tankItem) {
        if (Util.isLink(tankItem)) {
            return Util.hasUUID(tankItem) ? Util.getFluidStorage(Util.getUUID(tankItem)) : null;
        }
        if (Util.hasUUID(tankItem)) {
            return TankStateManager.getState().getOrCreate(Util.getUUID(tankItem), Util.getType(tankItem));
        }
        UUID uuid = UUID.randomUUID();
        TankType type = Util.getType(tankItem);
        tankItem.set(TankStorage.UUIDComponentType, (Object)uuid);
        return TankStateManager.getState().getOrCreate(uuid, type);
    }

    @Nullable
    public static TankFluidStorageState getFluidStorage(ItemStack tankItem) {
        return Util.getFluidStorage(Util.getUUID(tankItem));
    }

    @Nullable
    public static TankFluidStorageState getFluidStorage(UUID uuid) {
        TankPersistentState state = TankStateManager.getState();
        return state.get(uuid);
    }

    public static boolean hasUUID(ItemStack tankItem) {
        return tankItem.has(TankStorage.UUIDComponentType);
    }

    public static UUID getUUID(ItemStack tankItem) {
        return (UUID)tankItem.get(TankStorage.UUIDComponentType);
    }

    public static TankOptions getOptionsOrDefault(ItemStack tankItem) {
        if (tankItem.has(TankStorage.OptionsComponentType)) {
            return (TankOptions)tankItem.get(TankStorage.OptionsComponentType);
        }
        return TankOptions.create();
    }

    public static InsertMode getInsertMode(ItemStack tankItem) {
        if (tankItem.has(TankStorage.OptionsComponentType)) {
            return ((TankOptions)tankItem.get(TankStorage.OptionsComponentType)).insertMode();
        }
        return InsertMode.ALL;
    }

    public static TankInteractionMode getInteractionMode(ItemStack tankItem) {
        if (tankItem.has(TankStorage.OptionsComponentType)) {
            return ((TankOptions)tankItem.get(TankStorage.OptionsComponentType)).interactionMode();
        }
        return TankInteractionMode.OPEN_SCREEN;
    }

    public static int getSelectedSlot(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(TankStorage.SelectedSlotComponentType, (Object)-1);
    }

    public static short getUniqueId(ItemStack tankItem) {
        if (!tankItem.has(TankStorage.OptionsComponentType)) {
            return 0;
        }
        return ((TankOptions)tankItem.get(TankStorage.OptionsComponentType)).uniqueId();
    }

    private static int clampSelectedSlot(ItemStack itemStack, int max) {
        int selectedSlot = Util.getSelectedSlot(itemStack);
        int clampedSelectedSlot = Math.min(selectedSlot, max);
        if (clampedSelectedSlot != selectedSlot) {
            itemStack.set(TankStorage.SelectedSlotComponentType, (Object)clampedSelectedSlot);
        }
        return clampedSelectedSlot;
    }

    public static TankType getType(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof TankItem) {
            TankItem tankItem = (TankItem)item;
            return tankItem.type;
        }
        return (TankType)stack.getOrDefault(TankStorage.TankTypeComponentType, (Object)TankStorage.TANK_TYPES[0]);
    }

    public static boolean isTank(ItemStack stack) {
        return stack.getItem() instanceof TankItem;
    }

    public static boolean isLink(ItemStack stack) {
        return stack.getItem() instanceof TankLinkItem;
    }

    public static boolean isTankLike(ItemStack stack) {
        return stack.getItem() instanceof TankFunctionality;
    }

    public static FluidStack getFirstFluid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return FluidStack.EMPTY;
        }
        if (fluidHandler.getTanks() == 0) {
            return FluidStack.EMPTY;
        }
        return fluidHandler.getFluidInTank(0);
    }

    public static void trySync(ItemStack stack, ServerPlayer player) {
        if (!Util.isTankLike(stack)) {
            return;
        }
        if (!Util.hasUUID(stack)) {
            return;
        }
        TankFluidStorageState tank = Util.getFluidStorage(stack);
        if (tank == null) {
            return;
        }
        tank.sync(player);
        Util.clampSelectedSlot(stack, tank.getUniqueFluids().size() - 1);
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandlerFromItem(ItemStack itemStack, Void v) {
        return Util.getFluidHandlerFromItem(itemStack);
    }

    @Nullable
    public static TankFluidHandler getFluidHandlerFromItem(ItemStack itemStack) {
        if (Util.isClient()) {
            return Util.getClientFluidHandler(itemStack);
        }
        return Util.getServerFluidHandler(itemStack);
    }

    @Nullable
    private static TankFluidHandler getClientFluidHandler(ItemStack itemStack) {
        if (!Util.hasUUID(itemStack)) {
            return null;
        }
        CachedFluidStorageState tank = ClientTankCache.getAndQueueThrottledUpdate(Util.getUUID(itemStack), 20);
        if (tank == null) {
            return null;
        }
        InsertMode insertMode = Util.getInsertMode(itemStack);
        TankInteractionMode interactionMode = Util.getInteractionMode(itemStack);
        TankFluidHandler fluidHandler = tank.getFluidHandler(insertMode).withItem(itemStack);
        if (interactionMode == TankInteractionMode.OPEN_SCREEN) {
            return fluidHandler;
        }
        FluidStack selectedFluid = tank.getSelectedFluid(Util.getSelectedSlot(itemStack));
        if (selectedFluid == null) {
            return fluidHandler.insertOnly();
        }
        return fluidHandler.extractOnly(selectedFluid);
    }

    @Nullable
    private static TankFluidHandler getServerFluidHandler(ItemStack itemStack) {
        if (!Util.hasUUID(itemStack)) {
            return null;
        }
        TankFluidStorageState tank = Util.getFluidStorage(Util.getUUID(itemStack));
        if (tank == null) {
            return null;
        }
        InsertMode insertMode = Util.getInsertMode(itemStack);
        TankInteractionMode interactionMode = Util.getInteractionMode(itemStack);
        TankFluidHandler fluidHandler = tank.getFluidHandler(insertMode).withItem(itemStack);
        if (interactionMode == TankInteractionMode.OPEN_SCREEN) {
            return fluidHandler;
        }
        FluidStack selectedFluid = tank.getSelectedFluid(Util.getSelectedSlot(itemStack));
        if (selectedFluid == null) {
            return fluidHandler.insertOnly();
        }
        return fluidHandler.extractOnly(selectedFluid);
    }

    @Nullable
    public static FluidStack getSelectedFluid(ItemStack itemStack) {
        if (!Util.hasUUID(itemStack)) {
            return null;
        }
        int selectedslot = Util.getSelectedSlot(itemStack);
        if (Util.isClient()) {
            CachedFluidStorageState cached = ClientTankCache.getOrQueueUpdate(Util.getUUID(itemStack));
            if (cached == null) {
                return null;
            }
            return (selectedslot = Math.min(selectedslot, cached.getUniqueFluids().size() - 1)) == -1 ? null : cached.getUniqueFluids().get(selectedslot).fluid();
        }
        TankFluidStorageState tank = Util.getOrCreateFluidStorage(itemStack);
        if (tank == null) {
            return null;
        }
        List<LargeFluidSlotData> fluids = tank.getUniqueFluids();
        selectedslot = Util.clampSelectedSlot(itemStack, fluids.size() - 1);
        return selectedslot == -1 ? null : fluids.get(selectedslot).fluid();
    }

    public static void clampSelectedSlotServer(ItemStack stack) {
        int max = Util.getFluidStorage(stack).getUniqueFluids().size() - 1;
        Util.clampSelectedSlot(stack, max);
    }

    public static void onToggleInteractionMode(Player player, ItemStack stack) {
        stack.update(TankStorage.OptionsComponentType, (Object)TankOptions.create(), TankOptions::nextInteractionMode);
        TankInteractionMode interactionMode = Util.getInteractionMode(stack);
        player.displayClientMessage(Texts.interactionMode(interactionMode), true);
    }

    @Nullable
    public static ItemStack getHeldTank(Player player) {
        if (Util.isTankLike(player.getMainHandItem())) {
            return player.getMainHandItem();
        }
        if (Util.isTankLike(player.getOffhandItem())) {
            return player.getOffhandItem();
        }
        return null;
    }

    public static boolean isClient() {
        return isClient.get();
    }

    public static boolean canPlaceFluid(Fluid fluid) {
        return fluid instanceof FlowingFluid;
    }
}

