/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankInteractionMode;

public class Texts {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    public static final Component UNLINKED = Component.translatable((String)"popup.tankstorage.unlinked");
    public static final Component FLUIDSLOT_HOVER_TOOLTIP = Component.translatable((String)"tooltip.tankstorage.insert_or_extract_desc").withStyle(ChatFormatting.GRAY);
    private static final Component INTERACTIONMODE_OPEN_SCREEN = Component.translatable((String)"popup.tankstorage.interactionmode.open_screen");
    private static final Component INTERACTIONMODE_BUCKET = Component.translatable((String)"popup.tankstorage.interactionmode.bucket");
    private static final Component INSERTMODE_ALL_POPUP = Component.translatable((String)"popup.tankstorage.insertmode.all");
    private static final Component INSERTMODE_FILTERED_POPUP = Component.translatable((String)"popup.tankstorage.insertmode.filtered");
    private static final Component INSERTMODE_VOID_OVERFLOW_POPUP = Component.translatable((String)"popup.tankstorage.insertmode.void_overflow");
    private static final Component INSERTMODE_ALL = Component.translatable((String)"title.tankstorage.insertmode.all").append("\n").append((Component)Component.translatable((String)"tooltip.tankstorage.insertmode.all").withStyle(ChatFormatting.DARK_GRAY));
    private static final Component INSERTMODE_FILTERED = Component.translatable((String)"title.tankstorage.insertmode.filtered").append("\n").append((Component)Component.translatable((String)"tooltip.tankstorage.insertmode.filtered").withStyle(ChatFormatting.DARK_GRAY));
    private static final Component INSERTMODE_VOID_OVERFLOW = Component.translatable((String)"title.tankstorage.insertmode.void_overflow").append("\n").append((Component)Component.translatable((String)"tooltip.tankstorage.insertmode.void_overflow").withStyle(ChatFormatting.DARK_GRAY));

    public static Component interactionMode(TankInteractionMode interactionMode) {
        return switch (interactionMode) {
            default -> throw new MatchException(null, null);
            case TankInteractionMode.OPEN_SCREEN -> INTERACTIONMODE_OPEN_SCREEN;
            case TankInteractionMode.BUCKET -> INTERACTIONMODE_BUCKET;
        };
    }

    public static Component insertModePopup(InsertMode insertMode) {
        return switch (insertMode) {
            default -> throw new MatchException(null, null);
            case InsertMode.ALL -> INSERTMODE_ALL_POPUP;
            case InsertMode.FILTERED -> INSERTMODE_FILTERED_POPUP;
            case InsertMode.VOID_OVERFLOW -> INSERTMODE_VOID_OVERFLOW_POPUP;
        };
    }

    public static Component insertModeTooltip(InsertMode insertMode) {
        return switch (insertMode) {
            default -> throw new MatchException(null, null);
            case InsertMode.ALL -> INSERTMODE_ALL;
            case InsertMode.FILTERED -> INSERTMODE_FILTERED;
            case InsertMode.VOID_OVERFLOW -> INSERTMODE_VOID_OVERFLOW;
        };
    }

    public static Component slotSizeTooltip(int slotSize) {
        String formattedSlotSize = NUMBER_FORMAT.format(slotSize / 1000);
        return Component.translatable((String)"tooltip.tankstorage.slotsize", (Object[])new Object[]{formattedSlotSize});
    }

    public static Component slotCountTooltip(int slotCount) {
        return Component.translatable((String)"tooltip.tankstorage.numslots", (Object[])new Object[]{slotCount});
    }
}

