/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankInteractionMode;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record TankOptions(InsertMode insertMode, TankInteractionMode interactionMode, short uniqueId) {
    private static final Random random = new Random();
    public static final Codec<TankOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("insertMode").forGetter(t -> (byte)t.insertMode.ordinal()), (App)Codec.BYTE.fieldOf("interactionMode").forGetter(t -> (byte)t.interactionMode.ordinal()), (App)Codec.SHORT.fieldOf("uniqueId").forGetter(TankOptions::uniqueId)).apply((Applicative)instance, TankOptions::of));
    public static final StreamCodec<FriendlyByteBuf, TankOptions> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InsertMode.class), TankOptions::insertMode, (StreamCodec)NeoForgeStreamCodecs.enumCodec(TankInteractionMode.class), TankOptions::interactionMode, (StreamCodec)ByteBufCodecs.SHORT, TankOptions::uniqueId, TankOptions::new);

    public static TankOptions create() {
        return new TankOptions(InsertMode.ALL, TankInteractionMode.OPEN_SCREEN, (short)random.nextInt());
    }

    private static TankOptions of(byte insertMode, byte interactionMode, short uniqueId) {
        return new TankOptions(InsertMode.values()[insertMode], TankInteractionMode.values()[interactionMode], uniqueId);
    }

    public TankOptions nextInteractionMode() {
        return new TankOptions(this.insertMode, this.interactionMode.next(), this.uniqueId);
    }

    public TankOptions nextInsertMode() {
        return new TankOptions(this.insertMode.next(), this.interactionMode, this.uniqueId);
    }
}

