/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.state;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.state.TankFluidStorageState;
import net.natte.tankstorage.state.TankSerializer;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class TankPersistentState
extends SavedData {
    private static final String TANK_DATA_KEY = "tank";
    private final Map<UUID, TankFluidStorageState> TANK_MAP = new HashMap<UUID, TankFluidStorageState>();

    public static TankPersistentState createFromNbt(CompoundTag nbtCompound, HolderLookup.Provider registryLookup) {
        TankPersistentState state = new TankPersistentState();
        state.TANK_MAP.clear();
        if (!FMLLoader.isProduction()) {
            TankStorage.LOGGER.debug("Loading tanks from nbt");
        }
        Tag tankNbt = nbtCompound.get(TANK_DATA_KEY);
        List tanks = (List)TankSerializer.CODEC.parse((DynamicOps)registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tankNbt).getOrThrow();
        for (TankFluidStorageState tank : tanks) {
            state.TANK_MAP.put(tank.uuid, tank);
        }
        if (!FMLLoader.isProduction()) {
            TankStorage.LOGGER.debug("Loading done");
        }
        return state;
    }

    public CompoundTag save(CompoundTag nbtCompound, HolderLookup.Provider registryLookup) {
        if (!FMLLoader.isProduction()) {
            TankStorage.LOGGER.debug("Saving tanks to nbt");
        }
        List<TankFluidStorageState> tanks = List.copyOf(this.TANK_MAP.values());
        Tag tankNbt = (Tag)TankSerializer.CODEC.encodeStart((DynamicOps)registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), tanks).getOrThrow();
        nbtCompound.put(TANK_DATA_KEY, tankNbt);
        if (!FMLLoader.isProduction()) {
            TankStorage.LOGGER.debug("Saving done");
        }
        return nbtCompound;
    }

    @Nullable
    public TankFluidStorageState get(UUID uuid) {
        return this.TANK_MAP.get(uuid);
    }

    @Nullable
    public TankFluidStorageState getOrCreate(UUID uuid, TankType type) {
        TankFluidStorageState tank = this.TANK_MAP.get(uuid);
        if (tank == null) {
            tank = TankFluidStorageState.create(type, uuid);
            this.set(uuid, tank);
        }
        if (tank.type != type) {
            tank = tank.asType(type);
            this.set(uuid, tank);
        }
        return tank;
    }

    public void set(UUID uuid, TankFluidStorageState tank) {
        this.TANK_MAP.put(uuid, tank);
    }
}

