/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.state;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.packet.client.TankPacketS2C;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankFluidHandler;
import net.natte.tankstorage.storage.TankSingleFluidStorage;
import net.natte.tankstorage.sync.SyncSubscriptionManager;
import net.natte.tankstorage.util.FluidSlotData;
import net.natte.tankstorage.util.HashableFluidVariant;
import net.natte.tankstorage.util.LargeFluidSlotData;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TankFluidStorageState {
    public TankType type;
    public UUID uuid;
    private List<TankSingleFluidStorage> fluidStorageParts;
    private short revision = 0;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private List<LargeFluidSlotData> uniqueFluids;

    public TankFluidStorageState(TankType type, UUID uuid, List<FluidSlotData> fluidSlots) {
        this(type, uuid);
        this.fluidStorageParts = new ArrayList<TankSingleFluidStorage>();
        for (FluidSlotData slot : fluidSlots) {
            TankSingleFluidStorage fluidSlot = new TankSingleFluidStorage(this.type.getCapacity(), slot.amount(), slot.fluidVariant(), slot.isLocked());
            fluidSlot.setMarkDirtyListener(this::markDirty);
            this.fluidStorageParts.add(fluidSlot);
        }
    }

    private TankFluidStorageState(TankType type, UUID uuid) {
        this.type = type;
        this.uuid = uuid;
    }

    public void addOnChangeListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void removeOnChangeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    public TankFluidHandler getFluidHandler(InsertMode insertMode) {
        return new TankFluidHandler(this.fluidStorageParts, insertMode);
    }

    public TankFluidStorageState asType(TankType type) {
        if (this.type != type) {
            if (type.size() < this.type.size()) {
                return this;
            }
            return this.changeType(type);
        }
        return this;
    }

    public TankFluidStorageState changeType(TankType type) {
        int i;
        if (!FMLLoader.isProduction()) {
            TankStorage.LOGGER.debug("Upgrading tank from " + this.type.getName() + " to " + type.getName() + " uuid " + String.valueOf(this.uuid));
        }
        TankFluidStorageState tank = new TankFluidStorageState(type, this.uuid);
        tank.fluidStorageParts = new ArrayList<TankSingleFluidStorage>();
        for (i = 0; i < this.fluidStorageParts.size(); ++i) {
            TankSingleFluidStorage oldFluidStorage = this.fluidStorageParts.get(i);
            TankSingleFluidStorage newFluidSlot = new TankSingleFluidStorage(type.getCapacity(), oldFluidStorage.getAmount(), oldFluidStorage.getFluid(), oldFluidStorage.isLocked());
            newFluidSlot.setMarkDirtyListener(tank::markDirty);
            tank.fluidStorageParts.add(newFluidSlot);
        }
        for (i = this.fluidStorageParts.size(); i < type.size(); ++i) {
            TankSingleFluidStorage newFluidSlot = new TankSingleFluidStorage(type.getCapacity(), 0, FluidStack.EMPTY, false);
            newFluidSlot.setMarkDirtyListener(tank::markDirty);
            tank.fluidStorageParts.add(newFluidSlot);
        }
        tank.markDirty();
        return tank;
    }

    public static TankFluidStorageState create(TankType type, UUID uuid) {
        TankFluidStorageState tank = new TankFluidStorageState(type, uuid);
        ArrayList<TankSingleFluidStorage> fluidStorageParts = new ArrayList<TankSingleFluidStorage>(type.size());
        for (int i = 0; i < type.size(); ++i) {
            TankSingleFluidStorage tankSingleFluidStorage = new TankSingleFluidStorage(type.getCapacity());
            tankSingleFluidStorage.setMarkDirtyListener(tank::markDirty);
            fluidStorageParts.add(tankSingleFluidStorage);
        }
        tank.fluidStorageParts = fluidStorageParts;
        return tank;
    }

    public TankSingleFluidStorage getPart(int slot) {
        return this.fluidStorageParts.get(slot);
    }

    public List<FluidSlotData> getFluidSlots() {
        ArrayList<FluidSlotData> fluids = new ArrayList<FluidSlotData>();
        for (TankSingleFluidStorage part : this.fluidStorageParts) {
            fluids.add(new FluidSlotData(part.getFluid(), this.type.getCapacity(), part.getAmount(), part.isLocked()));
        }
        return fluids;
    }

    public List<LargeFluidSlotData> getUniqueFluids() {
        if (this.uniqueFluids == null) {
            LinkedHashMap<HashableFluidVariant, Long> counts = new LinkedHashMap<HashableFluidVariant, Long>();
            for (TankSingleFluidStorage part : this.fluidStorageParts) {
                if (part.getAmount() <= 0 && (!part.isLocked() || part.getFluid().isEmpty())) continue;
                counts.merge(new HashableFluidVariant(part.getFluid()), Long.valueOf(part.getAmount()), Long::sum);
            }
            ArrayList<LargeFluidSlotData> uniqueFluids = new ArrayList<LargeFluidSlotData>();
            counts.forEach((fluidVariant, count) -> uniqueFluids.add(new LargeFluidSlotData(fluidVariant.fluidStack(), 0L, (long)count, false)));
            this.uniqueFluids = uniqueFluids;
        }
        return this.uniqueFluids;
    }

    public short getRevision() {
        return this.revision;
    }

    private void updateRevision() {
        this.revision = (short)(this.revision + 1 & Short.MAX_VALUE);
    }

    public void markDirty() {
        this.uniqueFluids = null;
        this.updateRevision();
        for (Runnable listener : this.listeners) {
            listener.run();
        }
        SyncSubscriptionManager.setChanged(this.uuid);
    }

    public void sync(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TankPacketS2C(this.uuid, this.getRevision(), this.getFluidSlots()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public TankType getType() {
        return this.type;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public FluidStack getSelectedFluid(int selectedSlot) {
        return (selectedSlot = Mth.clamp((int)selectedSlot, (int)-1, (int)(this.getUniqueFluids().size() - 1))) == -1 ? null : this.getUniqueFluids().get(selectedSlot).fluid();
    }
}

