/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.block.TankDockBlockEntity;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.gui.FluidSlot;
import net.natte.tankstorage.gui.LockedSlot;
import net.natte.tankstorage.packet.screenHandler.SyncFluidPacketS2C;
import net.natte.tankstorage.packet.server.LockSlotPacketC2S;
import net.natte.tankstorage.state.TankFluidStorageState;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankFluidHandler;
import net.natte.tankstorage.storage.TankSingleFluidStorage;
import net.natte.tankstorage.util.FluidSlotData;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TankMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final ItemStack tankItem;
    private final TankType tankType;
    private final TankFluidStorageState tank;
    private final TankFluidHandler fluidStorage;
    private final int slotWithOpenedTank;
    private Runnable onChangeListener;
    @Nullable
    private ServerPlayer player;
    private List<FluidSlotData> trackedFluids;

    public TankMenu(int syncId, Inventory playerInventory, TankFluidStorageState tank, TankType tankType, ItemStack tankItem, int slot, ContainerLevelAccess access) {
        super((MenuType)TankStorage.TANK_MENU.get(), syncId);
        int x;
        this.tankItem = tankItem;
        this.tank = tank;
        this.tankType = tankType;
        this.slotWithOpenedTank = slot;
        this.access = access;
        this.fluidStorage = this.tank.getFluidHandler(InsertMode.ALL);
        Player player = playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            this.onChangeListener = this::broadcastChanges;
            tank.addOnChangeListener(this.onChangeListener);
            this.player = serverPlayerEntity;
            this.trackedFluids = new ArrayList<FluidSlotData>(this.tankType.size());
            for (int i = 0; i < this.tankType.size(); ++i) {
                this.trackedFluids.add(new FluidSlotData(FluidStack.EMPTY, 0, 0, false));
            }
        }
        int rows = this.tankType.height();
        int cols = this.tankType.width();
        for (int y = 0; y < rows; ++y) {
            for (x = 0; x < cols; ++x) {
                int slotIndex = x + y * cols;
                int slotX = 8 + x * 18 + (9 - cols) * 9;
                int slotY = 18 + y * 18;
                this.addSlot(new FluidSlot(this.tank.getPart(slotIndex), slotX, slotY));
            }
        }
        int inventoryY = 32 + rows * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                if (slot == x2 + y * 9 + 9) {
                    this.addSlot(new LockedSlot((Container)playerInventory, x2 + y * 9 + 9, 8 + x2 * 18, inventoryY + y * 18));
                    continue;
                }
                this.addSlot(new Slot((Container)playerInventory, x2 + y * 9 + 9, 8 + x2 * 18, inventoryY + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            if (slot == x) {
                this.addSlot(new LockedSlot((Container)playerInventory, x, 8 + x * 18, inventoryY + 58));
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, inventoryY + 58));
        }
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }

    public ItemStack getTankItem() {
        return this.tankItem;
    }

    public ItemStack quickMoveStack(Player playerEntity, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot instanceof FluidSlot) {
            return ItemStack.EMPTY;
        }
        IItemHandler playerInventory = (IItemHandler)playerEntity.getCapability(Capabilities.ItemHandler.ENTITY);
        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)slot.getItem(), (IFluidHandler)this.fluidStorage, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (Player)playerEntity, (boolean)true);
        if (result.isSuccess()) {
            slot.set(result.getResult());
            if (!playerEntity.level().isClientSide) {
                this.tank.sync((ServerPlayer)playerEntity);
                Util.trySync(slot.getItem(), (ServerPlayer)playerEntity);
            }
            return ItemStack.EMPTY;
        }
        ItemStack newStack = ItemStack.EMPTY;
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (slotIndex < this.tankType.size()) {
                return ItemStack.EMPTY;
            }
            if (slotIndex < this.slots.size() - 9 ? !this.moveItemStackTo(originalStack, this.slots.size() - 9, this.slots.size(), false) : !this.moveItemStackTo(originalStack, this.tankType.size(), this.slots.size() - 9, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        if (!AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)TankStorage.TANK_DOCK_BLOCK.get()))) {
            return false;
        }
        return (Boolean)this.access.evaluate((world, pos) -> {
            BlockEntity patt0$temp = world.getBlockEntity(pos);
            if (!(patt0$temp instanceof TankDockBlockEntity)) {
                return false;
            }
            TankDockBlockEntity blockEntity = (TankDockBlockEntity)patt0$temp;
            if (!blockEntity.hasTank()) {
                return false;
            }
            if (!blockEntity.getTank().has(TankStorage.UUIDComponentType)) {
                return false;
            }
            if (!((UUID)blockEntity.getTank().get(TankStorage.UUIDComponentType)).equals(this.tank.uuid)) {
                return false;
            }
            return true;
        }, (Object)true);
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        Slot slot;
        if (!(actionType != ClickType.SWAP || ((Slot)this.slots.get(slotIndex)).mayPickup(player) && button != this.slotWithOpenedTank)) {
            return;
        }
        Slot slot2 = slot = slotIndex >= 0 ? (Slot)this.slots.get(slotIndex) : null;
        if (!(slot instanceof FluidSlot)) {
            super.clicked(slotIndex, button, actionType, player);
            return;
        }
        if (actionType != ClickType.PICKUP && actionType != ClickType.PICKUP_ALL) {
            return;
        }
        Level world = player.level();
        if (world.isClientSide) {
            return;
        }
        TankSingleFluidStorage slotFluidStorage = this.tank.getPart(slotIndex);
        IItemHandler playerInventory = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (button == 1) {
            FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)this.getCarried(), (IFluidHandler)slotFluidStorage.getFluidHandler(), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (result.isSuccess()) {
                this.setCarried(result.getResult());
                this.tank.sync((ServerPlayer)player);
                Util.trySync(this.getCarried(), (ServerPlayer)player);
            }
        } else {
            FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)this.getCarried(), (IFluidHandler)slotFluidStorage.getFluidHandler(), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (result.isSuccess()) {
                this.tank.sync((ServerPlayer)player);
                Util.trySync(this.getCarried(), (ServerPlayer)player);
                this.setCarried(result.getResult());
            }
        }
    }

    public boolean lockSlot(int slot, FluidStack fluidVariant, boolean shouldLock) {
        if (slot < 0 || slot >= this.slots.size()) {
            return false;
        }
        Object object = this.slots.get(slot);
        if (!(object instanceof FluidSlot)) {
            return false;
        }
        FluidSlot fluidSlot = (FluidSlot)((Object)object);
        if (shouldLock && fluidSlot.getAmount() > 0 && !FluidStack.isSameFluidSameComponents((FluidStack)fluidSlot.getFluid(), (FluidStack)fluidVariant)) {
            return false;
        }
        this.tank.getPart(slot).lock(fluidVariant, shouldLock);
        return true;
    }

    public boolean lockSlot(int slot, FluidStack fluidVariant) {
        return this.lockSlot(slot, fluidVariant, true);
    }

    public boolean unlockSlot(int slot) {
        return this.lockSlot(slot, null, false);
    }

    public void handleSlotLock(FluidSlot slot, ItemStack carried) {
        boolean shouldUnLock;
        FluidStack cursorFluid = FluidUtil.getFluidContained((ItemStack)carried).orElse(FluidStack.EMPTY);
        int hoveredSlotIndex = slot.index;
        FluidStack slotFluid = slot.getFluid();
        boolean isSlotEmpty = slot.getAmount() == 0;
        boolean bl = shouldUnLock = slot.isLocked() && (cursorFluid.isEmpty() || slot.getAmount() > 0 || FluidStack.isSameFluidSameComponents((FluidStack)cursorFluid, (FluidStack)slotFluid));
        if (shouldUnLock) {
            this.unlockSlot(slot.index);
        } else {
            this.lockSlot(slot.index, isSlotEmpty ? cursorFluid : slotFluid);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(this.containerId, hoveredSlotIndex, isSlotEmpty ? cursorFluid : slotFluid, !shouldUnLock), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void syncFluidSlot(int slot, ServerPlayer player) {
        TankSingleFluidStorage singleFluidStorage = this.tank.getPart(slot);
        this.trackedFluids.set(slot, FluidSlotData.from(singleFluidStorage));
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncFluidPacketS2C(this.containerId, slot, FluidSlotData.from(singleFluidStorage)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void removed(Player player) {
        if (this.onChangeListener != null) {
            this.tank.removeOnChangeListener(this.onChangeListener);
        }
        super.removed(player);
    }

    public void updateFluidSlot(int slot, FluidSlotData fluidSlotData) {
        if (slot < 0 || slot >= this.tankType.size()) {
            return;
        }
        this.tank.getPart(slot).update(fluidSlotData.amount(), fluidSlotData.fluidVariant(), fluidSlotData.isLocked());
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        for (int i = 0; i < this.trackedFluids.size(); ++i) {
            FluidSlotData trackedFluidSlot = this.trackedFluids.get(i);
            if (trackedFluidSlot.equalsOther(this.tank.getPart(i))) continue;
            this.syncFluidSlot(i, this.player);
        }
    }

    public TankType getTankType() {
        return this.tankType;
    }
}

