/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.natte.tankstorage.cache.CachedFluidStorageState;
import net.natte.tankstorage.cache.ClientTankCache;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.item.tooltip.TankTooltipData;
import net.natte.tankstorage.menu.TankMenuFactory;
import net.natte.tankstorage.state.TankFluidStorageState;
import net.natte.tankstorage.storage.TankInteractionMode;
import net.natte.tankstorage.util.BucketInteraction;
import net.natte.tankstorage.util.Texts;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.common.util.Lazy;

public class TankFunctionality
extends Item {
    public TankFunctionality(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        boolean shouldOpenScreen;
        boolean shouldToggle;
        ItemStack stack = player.getItemInHand(hand);
        TankInteractionMode interactionMode = Util.getInteractionMode(stack);
        Lazy bucketInteractionResult = Lazy.of(() -> BucketInteraction.interactFluid(world, player, hand, stack));
        boolean bl = shouldToggle = player.isShiftKeyDown() && (interactionMode == TankInteractionMode.OPEN_SCREEN || bucketInteractionResult.get() == InteractionResult.PASS);
        if (shouldToggle) {
            if (!world.isClientSide) {
                Util.onToggleInteractionMode(player, stack);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        boolean bl2 = shouldOpenScreen = interactionMode == TankInteractionMode.OPEN_SCREEN || bucketInteractionResult.get() == InteractionResult.PASS && !this.preventOpenScreenOnFluidClick(world, player);
        if (shouldOpenScreen) {
            return this.tryOpenScreen(world, player, stack);
        }
        return ((InteractionResult)bucketInteractionResult.get()).consumesAction() ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.fail((Object)stack);
    }

    private boolean preventOpenScreenOnFluidClick(Level level, Player player) {
        Vec3 vec31;
        Vec3 vec3 = player.getEyePosition();
        return level.clip(new ClipContext(vec3, vec31 = vec3.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(player.blockInteractionRange() + 1.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player)).getType() != HitResult.Type.MISS;
    }

    private InteractionResultHolder<ItemStack> tryOpenScreen(Level world, Player player, ItemStack stack) {
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        TankFluidStorageState tank = Util.getOrCreateFluidStorage(stack);
        if (tank == null) {
            player.displayClientMessage(Texts.UNLINKED, true);
            return InteractionResultHolder.fail((Object)stack);
        }
        TankMenuFactory menu = new TankMenuFactory(tank, stack, player.getInventory().selected, ContainerLevelAccess.NULL);
        menu.open(player);
        return InteractionResultHolder.success((Object)stack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        int selectedSlot;
        if (!Util.hasUUID(stack)) {
            return Optional.empty();
        }
        CachedFluidStorageState tank = ClientTankCache.getAndQueueThrottledUpdate(Util.getUUID(stack), 20);
        if (tank == null) {
            return Optional.empty();
        }
        TankInteractionMode interactionMode = Util.getInteractionMode(stack);
        int n = selectedSlot = interactionMode == TankInteractionMode.BUCKET ? Util.getSelectedSlot(stack) : -2;
        if (tank.getUniqueFluids().isEmpty() && selectedSlot != -1) {
            return Optional.empty();
        }
        return Optional.of(new TankTooltipData(tank.getUniqueFluids(), selectedSlot));
    }

    public static BlockHitResult raycast(Level world, Player player, ClipContext.Fluid fluidHandling) {
        return Item.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)fluidHandling);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipType) {
        TankType type;
        if (((Boolean)Util.isShiftDown.get()).booleanValue() && Util.hasUUID(stack)) {
            tooltip.add((Component)Component.literal((String)Util.getUUID(stack).toString()).withStyle(ChatFormatting.DARK_AQUA));
        }
        if ((type = Util.getType(stack)) != null) {
            tooltip.add(Texts.slotSizeTooltip(type.getCapacity()));
            tooltip.add(Texts.slotCountTooltip(type.size()));
        }
        super.appendHoverText(stack, context, tooltip, tooltipType);
    }
}

