/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.compat.rei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.natte.tankstorage.client.screen.TankScreen;
import net.natte.tankstorage.gui.FluidSlot;
import net.natte.tankstorage.menu.TankMenu;
import net.natte.tankstorage.packet.server.LockSlotPacketC2S;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TankDraggableStackVisitor
implements DraggableStackVisitor<TankScreen> {
    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof TankScreen;
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<TankScreen> context, DraggableStack dragged) {
        Slot slot = ((TankScreen)context.getScreen()).getSlotUnderMouse();
        if (!(slot instanceof FluidSlot)) {
            return DraggedAcceptorResult.PASS;
        }
        FluidSlot fluidSlot = (FluidSlot)slot;
        net.neoforged.neoforge.fluids.FluidStack fluidStack = this.getFluid(dragged);
        if (fluidStack == null) {
            return DraggedAcceptorResult.PASS;
        }
        TankMenu menu = (TankMenu)((TankScreen)context.getScreen()).getMenu();
        menu.lockSlot(fluidSlot.index, fluidStack);
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(menu.containerId, fluidSlot.index, fluidStack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return DraggedAcceptorResult.ACCEPTED;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<TankScreen> context, DraggableStack dragged) {
        net.neoforged.neoforge.fluids.FluidStack fluidStack = this.getFluid(dragged);
        if (fluidStack == null) {
            return Stream.empty();
        }
        TankScreen screen = (TankScreen)context.getScreen();
        int left = screen.getGuiLeft();
        int top = screen.getGuiTop();
        return ((TankMenu)screen.getMenu()).slots.stream().filter(slot -> {
            FluidSlot fluidSlot;
            return slot instanceof FluidSlot && ((fluidSlot = (FluidSlot)((Object)slot)).getAmount() == 0 || !fluidSlot.isLocked() && net.neoforged.neoforge.fluids.FluidStack.isSameFluidSameComponents((net.neoforged.neoforge.fluids.FluidStack)fluidSlot.getFluid(), (net.neoforged.neoforge.fluids.FluidStack)fluidStack));
        }).map(slot -> DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(left + slot.x, top + slot.y, 16, 16)));
    }

    @Nullable
    private net.neoforged.neoforge.fluids.FluidStack getFluid(DraggableStack draggableStack) {
        Object object = draggableStack.getStack().getValue();
        if (object instanceof FluidStack) {
            FluidStack archFluidStack = (FluidStack)object;
            return FluidStackHooksForge.toForge((FluidStack)archFluidStack);
        }
        object = draggableStack.getStack().getValue();
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return FluidUtil.getFluidContained((ItemStack)itemStack).orElse(null);
        }
        return null;
    }
}

