/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Items;
import net.natte.tankstorage.client.rendering.FluidRenderer;
import net.natte.tankstorage.item.tooltip.TankTooltipData;
import net.natte.tankstorage.util.LargeFluidSlotData;
import net.natte.tankstorage.util.Util;

public class TankTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = Util.ID("textures/gui/widgets.png");
    private final List<LargeFluidSlotData> fluids;
    private final int selectedSlot;

    public TankTooltipComponent(TankTooltipData tooltipData) {
        this.fluids = tooltipData.fluids();
        this.selectedSlot = tooltipData.selectedSlot();
    }

    public int getWidth(Font textRenderer) {
        return this.getColumns() * 18 + 2;
    }

    public int getHeight() {
        return this.getRows() * 18 + 2 + 4;
    }

    private int getRows() {
        return Math.max(1, Mth.ceil((double)((double)this.fluids.size() / 9.0)));
    }

    private int getColumns() {
        return Math.min(9, this.fluids.size());
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        this.drawBackground(x, y, context);
        this.drawFluids(textRenderer, x, y, context);
        if (this.selectedSlot != -2) {
            this.drawSlotHighlight(x, y, context);
        }
    }

    private void drawBackground(int x, int y, GuiGraphics context) {
        int i;
        int row = 0;
        int col = 0;
        int n = i = this.selectedSlot == -1 ? -1 : 0;
        while (i < this.fluids.size()) {
            context.blit(TEXTURE, x + col * 18, y + row * 18, 20, 128, 20, 20);
            if (++col == 9) {
                col = 0;
                ++row;
            }
            ++i;
        }
    }

    private void drawFluids(Font textRenderer, int x, int y, GuiGraphics context) {
        int row = 0;
        int col = 0;
        if (this.selectedSlot == -1) {
            context.blit(TEXTURE, x + 1, y + 1, 1, 129, 18, 18);
            context.renderItem(Items.BUCKET.getDefaultInstance(), x + 2, y + 2);
            ++col;
        }
        for (LargeFluidSlotData fluid : this.fluids) {
            this.drawFluidInSlot(fluid, context, textRenderer, x + col * 18 + 1, y + row * 18 + 1);
            if (++col != 9) continue;
            col = 0;
            ++row;
        }
    }

    private void drawFluidInSlot(LargeFluidSlotData fluid, GuiGraphics context, Font textRenderer, int x, int y) {
        context.blit(TEXTURE, x, y, 1, 129, 18, 18);
        FluidRenderer.drawFluidInGui(context, fluid.fluid(), x + 1, y + 1, false);
        FluidRenderer.drawFluidCount(textRenderer, context, fluid.amount(), x + 1, y + 1);
    }

    private void drawSlotHighlight(int x, int y, GuiGraphics context) {
        int slotIndex = this.selectedSlot == -1 ? 0 : this.selectedSlot;
        int xOffset = x + 18 * (slotIndex % 9) - 1;
        int yOffset = y + 18 * (slotIndex / 9) - 1;
        context.blit(TEXTURE, xOffset, yOffset, 25, 23, 22, 22);
    }
}

