/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client.screen;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.natte.tankstorage.client.TankStorageClient;
import net.natte.tankstorage.client.helpers.FluidHelper;
import net.natte.tankstorage.client.rendering.FluidRenderer;
import net.natte.tankstorage.client.screen.InsertModeButtonWidget;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.gui.FluidSlot;
import net.natte.tankstorage.menu.TankMenu;
import net.natte.tankstorage.util.Texts;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankScreen
extends AbstractContainerScreen<TankMenu> {
    private static final ResourceLocation WIDGETS_TEXTURE = Util.ID("textures/gui/widgets.png");
    private final ResourceLocation texture;
    private boolean isLockSlotKeyDown = false;
    private final int bgTextureWidth;
    private final int bgTextureHeight;

    public TankScreen(TankMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        TankType type = handler.getTankType();
        this.texture = Util.ID("textures/gui/" + type.width() + "x" + type.height() + ".png");
        this.imageWidth = 176;
        this.imageHeight = 114 + type.height() * 18;
        this.inventoryLabelY += type.height() * 18 - 52;
        this.bgTextureWidth = Mth.ceil((double)((double)this.imageWidth / 256.0)) * 256;
        this.bgTextureHeight = Mth.ceil((double)((double)this.imageHeight / 256.0)) * 256;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new InsertModeButtonWidget(Util.getInsertMode(((TankMenu)this.menu).getTankItem()), this.leftPos + this.titleLabelX + this.imageWidth - 31, this.topPos + this.titleLabelY - 4, 14, 14, WIDGETS_TEXTURE));
    }

    protected void renderBg(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        guiGraphics.blit(this.texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.bgTextureWidth, this.bgTextureHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.setFocused(null);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (!(slot instanceof FluidSlot)) {
            super.renderSlot(guiGraphics, slot);
            return;
        }
        FluidSlot fluidSlot = (FluidSlot)slot;
        FluidStack fluidVariant = fluidSlot.getFluid();
        if (!fluidVariant.isEmpty()) {
            FluidRenderer.drawFluidInGui(guiGraphics, fluidVariant, slot.x, slot.y, fluidSlot.getAmount() == 0);
            if (fluidSlot.getAmount() > 0) {
                FluidRenderer.drawFluidCount(this.font, guiGraphics, fluidSlot.getAmount(), slot.x, slot.y);
            }
        }
        if (fluidSlot.isLocked()) {
            guiGraphics.blit(WIDGETS_TEXTURE, fluidSlot.x, fluidSlot.y, 0, 46, 16, 16);
        }
    }

    protected void renderTooltip(GuiGraphics context, int x, int y) {
        boolean shouldAddFluidSlotInfo;
        Slot slot = this.hoveredSlot;
        if (!(slot instanceof FluidSlot)) {
            super.renderTooltip(context, x, y);
            return;
        }
        FluidSlot fluidSlot = (FluidSlot)slot;
        boolean hasCursorStack = !((TankMenu)this.menu).getCarried().isEmpty();
        boolean bl = shouldAddFluidSlotInfo = fluidSlot.getAmount() > 0 || fluidSlot.isLocked();
        if (!shouldAddFluidSlotInfo && !hasCursorStack) {
            return;
        }
        FluidStack fluidVariant = fluidSlot.getFluid();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (shouldAddFluidSlotInfo) {
            FluidHelper.appendTooltipForFluidStorage(tooltip, fluidVariant, fluidSlot.getAmount(), fluidSlot.getCapacity());
        }
        if (hasCursorStack) {
            tooltip.add(Texts.FLUIDSLOT_HOVER_TOOLTIP);
        }
        context.renderComponentTooltip(this.font, tooltip, x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof FluidSlot) {
            FluidSlot fluidSlot = (FluidSlot)slot;
            if (button == 0 && this.isLockSlotKeyDown) {
                ((TankMenu)this.menu).handleSlotLock(fluidSlot, ((TankMenu)this.menu).getCarried());
                this.skipNextRelease = true;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (TankStorageClient.lockSlotKeyBinding.matches(keyCode, scanCode)) {
            this.isLockSlotKeyDown = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (TankStorageClient.lockSlotKeyBinding.matches(keyCode, scanCode)) {
            this.isLockSlotKeyDown = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

