/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.natte.tankstorage.cache.CachedFluidStorageState;
import net.natte.tankstorage.client.TankStorageClient;
import net.natte.tankstorage.client.rendering.HudRenderer;
import net.natte.tankstorage.packet.server.SelectedSlotPacketC2S;
import net.natte.tankstorage.packet.server.UpdateTankOptionsPacketC2S;
import net.natte.tankstorage.storage.TankInteractionMode;
import net.natte.tankstorage.storage.TankOptions;
import net.natte.tankstorage.util.Texts;
import net.natte.tankstorage.util.Util;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class MouseEvents {
    public static void onScroll(InputEvent.MouseScrollingEvent event) {
        int newSelectedItemSlot;
        int scroll = -((int)Math.signum(event.getScrollDeltaY()));
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isShiftKeyDown()) {
            return;
        }
        HudRenderer preview = TankStorageClient.tankHudRenderer;
        if (!preview.isRendering()) {
            return;
        }
        CachedFluidStorageState cachedBankStorage = preview.getFluidStorage();
        int selectedItemSlot = preview.selectedSlot;
        preview.selectedSlot = newSelectedItemSlot = Mth.clamp((int)(selectedItemSlot + scroll), (int)-1, (int)(cachedBankStorage.getUniqueFluids().size() - 1));
        PacketDistributor.sendToServer((CustomPacketPayload)new SelectedSlotPacketC2S(preview.renderingFromHand == InteractionHand.MAIN_HAND, newSelectedItemSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        event.setCanceled(true);
    }

    public static void onToggleInteractionMode() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack tankItem = Util.getHeldTank((Player)player);
        if (tankItem == null) {
            return;
        }
        TankOptions options = Util.getOptionsOrDefault(tankItem).nextInteractionMode();
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateTankOptionsPacketC2S(options, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        TankInteractionMode interactionMode = options.interactionMode();
        player.displayClientMessage(Texts.interactionMode(interactionMode), true);
    }
}

