/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.natte.tankstorage.cache.CachedFluidStorageState;
import org.jetbrains.annotations.Nullable;

public class ClientTankCache {
    private static final Map<UUID, CachedFluidStorageState> CACHE = new HashMap<UUID, CachedFluidStorageState>();
    private static final Set<UUID> requestQueue = new HashSet<UUID>();
    private static final Map<UUID, Integer> throddledQueue = new HashMap<UUID, Integer>();
    public static boolean markDirtyForPreview = false;

    public static void put(UUID uuid, CachedFluidStorageState state) {
        CACHE.put(uuid, state);
        markDirtyForPreview = true;
    }

    @Nullable
    public static CachedFluidStorageState get(UUID uuid) {
        return CACHE.get(uuid);
    }

    @Nullable
    public static CachedFluidStorageState getOrQueueUpdate(UUID uuid) {
        CachedFluidStorageState state = ClientTankCache.get(uuid);
        if (state == null) {
            requestQueue.add(uuid);
        }
        return state;
    }

    @Nullable
    public static CachedFluidStorageState getAndQueueThrottledUpdate(UUID uuid, int ticks) {
        if (throddledQueue.containsKey(uuid)) {
            return ClientTankCache.get(uuid);
        }
        throddledQueue.put(uuid, ticks);
        requestQueue.add(uuid);
        return ClientTankCache.get(uuid);
    }

    public static Set<UUID> getQueue() {
        return requestQueue;
    }

    public static void clear() {
        requestQueue.clear();
        CACHE.clear();
    }

    public static void advanceThrottledQueue() {
        throddledQueue.entrySet().removeIf(entity -> (Integer)entity.getValue() <= 0);
        throddledQueue.replaceAll((uuid, ticksLeft) -> ticksLeft - 1);
    }
}

