/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.util.Mth;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankFluidHandler;
import net.natte.tankstorage.storage.TankSingleFluidStorage;
import net.natte.tankstorage.util.FluidSlotData;
import net.natte.tankstorage.util.HashableFluidVariant;
import net.natte.tankstorage.util.LargeFluidSlotData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CachedFluidStorageState {
    private final int revision;
    private final List<FluidSlotData> fluids;
    private List<LargeFluidSlotData> uniqueFluids;
    private List<TankSingleFluidStorage> parts;

    public CachedFluidStorageState(List<FluidSlotData> fluids, int revision) {
        this.fluids = fluids;
        this.revision = revision;
    }

    public int getRevision() {
        return this.revision;
    }

    public List<FluidSlotData> getFluids() {
        return this.fluids;
    }

    public TankFluidHandler getFluidHandler(InsertMode insertMode) {
        if (this.parts == null) {
            this.parts = this.fluids.stream().map(TankSingleFluidStorage::from).toList();
        }
        return new TankFluidHandler(this.parts, insertMode);
    }

    public List<LargeFluidSlotData> getUniqueFluids() {
        if (this.uniqueFluids == null) {
            LinkedHashMap<HashableFluidVariant, Long> counts = new LinkedHashMap<HashableFluidVariant, Long>();
            for (FluidSlotData fluidSlotData : this.fluids) {
                if (fluidSlotData.amount() <= 0 && (!fluidSlotData.isLocked() || fluidSlotData.fluidVariant().isEmpty())) continue;
                counts.merge(new HashableFluidVariant(fluidSlotData.fluidVariant()), Long.valueOf(fluidSlotData.amount()), Long::sum);
            }
            this.uniqueFluids = new ArrayList<LargeFluidSlotData>();
            counts.forEach((fluidVariant, count) -> this.uniqueFluids.add(new LargeFluidSlotData(fluidVariant.fluidStack(), 0L, (long)count, false)));
        }
        return this.uniqueFluids;
    }

    @Nullable
    public FluidStack getSelectedFluid(int selectedSlot) {
        return (selectedSlot = Mth.clamp((int)selectedSlot, (int)-1, (int)(this.getUniqueFluids().size() - 1))) == -1 ? null : this.getUniqueFluids().get(selectedSlot).fluid();
    }
}

