/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sussysniffers.mixin;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.sussysniffers.SussySniffers;
import cy.jdkdigital.sussysniffers.common.SnifferVariant;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sniffer.class})
public class MixinSniffer
extends Mob
implements VariantHolder<Holder<SnifferVariant>>,
OwnableEntity,
PlayerRideableJumping,
Saddleable {
    private static final EntityDataAccessor<Holder<SnifferVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Sniffer.class, (EntityDataSerializer)((EntityDataSerializer)SussySniffers.SNIFFER_VARIANT_SERIALIZER.get()));
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.defineId(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private UUID owner;

    protected MixinSniffer(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"dropSeed()V"}, cancellable=true)
    public void dropSussyStuff(CallbackInfo callbackInfo) {
        Sniffer that = (Sniffer)this;
        Level level = that.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((Integer)that.getEntityData().get(Sniffer.DATA_DROP_SEED_AT_TICK) == that.tickCount) {
                BlockPos sniffTarget = that.getBrain().getMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET).orElse(that.getHeadBlock().below());
                BlockEntity blockEntity = that.level().getBlockEntity(sniffTarget);
                if (blockEntity instanceof BrushableBlockEntity) {
                    BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)blockEntity;
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(SussySniffers.FAKE_PLAYER_UUID, "sussy_sniffer"));
                    brushableBlockEntity.unpackLootTable((Player)fakePlayer);
                    Block.popResourceFromFace((Level)serverLevel, (BlockPos)sniffTarget, (Direction)Direction.UP, (ItemStack)brushableBlockEntity.getItem());
                    Block block = brushableBlockEntity.getBlockState().getBlock();
                    if (block instanceof BrushableBlock) {
                        BrushableBlock brushableBlock = (BrushableBlock)block;
                        that.level().setBlock(sniffTarget, brushableBlock.getTurnsInto().defaultBlockState(), 3);
                    }
                    callbackInfo.cancel();
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"})
    public void defineVariantSynchedData(SynchedEntityData.Builder builder, CallbackInfo callbackInfo) {
        builder.define(DATA_VARIANT_ID, (Object)SussySniffers.SNIFFER_VARIANT_REGISTRY.getHolderOrThrow(SnifferVariant.DEFAULT_SNIFFER.getKey()));
        builder.define(DATA_SADDLED, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/entity/animal/sniffer/Sniffer;mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"})
    public InteractionResult useTameItem(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        if (!((InteractionResult)callbackInfo.getReturnValue()).consumesAction()) {
            if (this.getOwnerUUID() == null && player.getItemInHand(hand).is(SussySniffers.SNIFFER_TAME_ITEMS)) {
                player.getItemInHand(hand).consume(1, (LivingEntity)player);
                Sniffer that = (Sniffer)this;
                if (that.getRandom().nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)that, (Player)player)) {
                    this.setOwnerUUID(player.getUUID());
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)player;
                        CriteriaTriggers.TAME_ANIMAL.trigger(serverplayer, (Animal)that);
                    }
                    this.level().broadcastEntityEvent((Entity)that, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)that, (byte)6);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(player.getUUID()) && this.isSaddled()) {
                if (player.getItemInHand(hand).canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR)) {
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, MixinSniffer.getSlotForHand((InteractionHand)hand));
                    this.removeSaddle();
                    this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                    this.spawnAtLocation((ItemLike)Items.SADDLE);
                } else if (!this.level().isClientSide()) {
                    player.startRiding((Entity)this);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        return (InteractionResult)callbackInfo.getReturnValue();
    }

    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/entity/animal/sniffer/Sniffer;canDig()Z"})
    public boolean canDigWhenVehicle(CallbackInfoReturnable<Boolean> callbackInfo) {
        return (Boolean)callbackInfo.getReturnValue() != false && this.getFirstPassenger() == null;
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(SnifferVariant.getVariant(level, this.blockPosition()));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public float getScale() {
        return super.getScale() * ((SnifferVariant)this.getVariant().value()).size();
    }

    public void setVariant(Holder<SnifferVariant> variant) {
        Sniffer that = (Sniffer)this;
        that.getEntityData().set(DATA_VARIANT_ID, variant);
    }

    @NotNull
    public Holder<SnifferVariant> getVariant() {
        Sniffer that = (Sniffer)this;
        return (Holder)that.getEntityData().get(DATA_VARIANT_ID);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("variant", this.getVariant().unwrapKey().orElse(SnifferVariant.DEFAULT_SNIFFER.getKey()).location().toString());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("owner", this.getOwnerUUID());
        }
        compound.putBoolean("isSaddled", this.isSaddled());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("variant")) {
            SussySniffers.SNIFFER_VARIANT_REGISTRY.getHolder(ResourceLocation.tryParse((String)compound.getString("variant"))).ifPresent(this::setVariant);
        }
        if (compound.contains("owner")) {
            this.setOwnerUUID(compound.getUUID("owner"));
        }
        if (compound.getBoolean("isSaddled")) {
            this.getEntityData().set(DATA_SADDLED, (Object)true);
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    public void onPlayerJump(int i) {
    }

    public boolean canJump() {
        return false;
    }

    public void handleStartJump(int i) {
    }

    public void handleStopJump() {
    }

    protected void dropEquipment() {
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.getOwnerUUID() != null;
    }

    public void equipSaddle(ItemStack itemStack, @Nullable SoundSource soundSource) {
        this.getEntityData().set(DATA_SADDLED, (Object)true);
        if (soundSource != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.CAMEL_SADDLE, soundSource, 0.5f, 1.0f);
        }
    }

    private void removeSaddle() {
        this.getEntityData().set(DATA_SADDLED, (Object)false);
    }

    public boolean isSaddled() {
        return (Boolean)this.getEntityData().get(DATA_SADDLED);
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.isSaddled() && this.isVehicle() && this.getFirstPassenger() instanceof Player;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            return (Player)entity;
        }
        return super.getControllingPassenger();
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        float f = player.xxa * 0.5f;
        float f1 = player.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 1.2f;
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        Vec2 vec2 = new Vec2(player.getXRot() * 0.5f, player.getYRot());
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.3), this.getRandomY() + 0.8, this.getRandomZ(1.3), d0, d1, d2);
        }
    }
}

