/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.flywheel;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.material.CutoutShaders;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.part.InstanceTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.model.part.ModelTrees;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BellowsBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BellowsInstance
extends AbstractBlockEntityVisual<BellowsBlockTile>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(TextureAtlas.LOCATION_BLOCKS).mipmap(false).backfaceCulling(false).build();
    private final InstanceTree instances;
    private final InstanceTree center;
    private final InstanceTree top;
    private final InstanceTree bottom;
    private final InstanceTree leather;
    private final Matrix4f initialPose;
    private float lastProgress = Float.NaN;

    public BellowsInstance(VisualizationContext ctx, BellowsBlockTile blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.instances = InstanceTree.create((InstancerProvider)this.instancerProvider(), (ModelTree)ModelTrees.of((ModelLayerLocation)ClientRegistry.BELLOWS_MODEL, (net.minecraft.client.resources.model.Material)ModMaterials.BELLOWS_MATERIAL, (Material)MATERIAL));
        this.leather = this.instances.child("leather");
        this.top = this.instances.child("top");
        this.bottom = this.instances.child("bottom");
        this.center = this.instances.child("center");
        this.initialPose = this.createInitialPose();
    }

    private Matrix4f createInitialPose() {
        BlockPos visualPosition = this.getVisualPosition();
        Quaternionf rotation = this.getDirection().getRotation();
        return new Matrix4f().translate((float)visualPosition.getX(), (float)visualPosition.getY(), (float)visualPosition.getZ()).translate(0.5f, 0.5f, 0.5f).scale(0.9995f).rotate((Quaternionfc)rotation).scale(1.0f, -1.0f, -1.0f).translate(0.0f, -1.0f, 0.0f);
    }

    public void beginFrame(DynamicVisual.Context context) {
        float dh = ((BellowsBlockTile)this.blockEntity).getHeight(context.partialTick());
    }

    protected void _delete() {
        this.instances.delete();
    }

    public void updateLight(float v) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    private Direction getDirection() {
        return (Direction)this.blockState.getValue((Property)BellowsBlock.FACING);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        this.instances.traverse(consumer);
    }
}

