/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ModSoundType;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PlanterBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.neoforge.FarmersDelightCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;

public class FarmersDelightCompat {
    public static final ModSoundType STICK_TOMATO_SOUND = new ModSoundType(1.0f, 1.0f, () -> SoundEvents.CROP_BREAK, () -> SoundEvents.GRASS_STEP, () -> SoundEvents.WOOD_PLACE, () -> SoundEvents.GRASS_HIT, () -> SoundEvents.GRASS_FALL);
    public static final Supplier<Block> ROPE_TOMATO = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_tomatoes"), () -> new TomatoRopeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).forceSolidOff()));
    public static final Supplier<Block> STICK_TOMATOES = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("stick_tomatoes"), () -> new TomatoStickBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).forceSolidOff().sound((SoundType)STICK_TOMATO_SOUND)));

    public static void init() {
    }

    @Nullable
    public static BlockState getTomatoLoggedReplacement(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (FarmersDelightCompat.isTomatoVineClimbingConfigOn()) {
            if (state.is((Block)ModRegistry.ROPE.get())) {
                BlockState toPlace = ROPE_TOMATO.get().defaultBlockState();
                toPlace = Block.updateFromNeighbourShapes((BlockState)toPlace, (LevelAccessor)level, (BlockPos)pos);
                return toPlace;
            }
            if (state.is(ModRegistry.STICK_BLOCK.get())) {
                BlockState toPlace = STICK_TOMATOES.get().defaultBlockState();
                return toPlace;
            }
        }
        return null;
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isTomatoVineClimbingConfigOn() {
        return FarmersDelightCompatImpl.isTomatoVineClimbingConfigOn();
    }

    public static Block getStickTomato() {
        return STICK_TOMATOES.get();
    }

    public static void setupClient() {
        ClientHelper.registerRenderType((Block)ROPE_TOMATO.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)STICK_TOMATOES.get(), (RenderType)RenderType.cutout());
    }

    public static boolean canAddStickToTomato(BlockState blockstate, BooleanProperty axis) {
        if (blockstate.getBlock() == FarmersDelightCompat.getStickTomato()) {
            return (Boolean)blockstate.getValue((Property)axis) == false;
        }
        return false;
    }

    public static PlanterBlock makePlanterRich() {
        return new PlanterRichBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TERRACOTTA).strength(2.0f, 6.0f).requiresCorrectToolForDrops().randomTicks(), (Supplier<Block>)CompatObjects.RICH_SOIL);
    }

    public static class PlanterRichBlock
    extends PlanterBlock {
        private final Supplier<BlockState> richSoilDelegate = Suppliers.memoize(() -> ((Block)mimic.get()).defaultBlockState());

        public PlanterRichBlock(BlockBehaviour.Properties properties, Supplier<Block> mimic) {
            super(properties);
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
        }

        public List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
            return super.getDrops(blockState, builder);
        }

        public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
            if (CommonConfigs.Building.FD_PLANTER.get().booleanValue()) {
                this.richSoilDelegate.get().randomTick(worldIn, pos, rand);
            }
        }
    }

    private static class TomatoStickBlock
    extends TomatoLoggedBlock {
        public static final BooleanProperty AXIS_X = ModBlockProperties.AXIS_X;
        public static final BooleanProperty AXIS_Z = ModBlockProperties.AXIS_Z;

        public TomatoStickBlock(BlockBehaviour.Properties properties) {
            super(properties);
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
        }

        public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return StickBlock.getStickShape((Boolean)state.getValue((Property)AXIS_X), true, (Boolean)state.getValue((Property)AXIS_Z));
        }

        @Override
        public Block getInnerBlock() {
            return ModRegistry.STICK_BLOCK.get();
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            builder.add(new Property[]{AXIS_X, AXIS_Z});
            super.createBlockStateDefinition(builder);
        }

        public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
            if (!context.isSecondaryUseActive() && context.getItemInHand().is(Items.STICK)) {
                return switch (context.getClickedFace().getAxis()) {
                    case Direction.Axis.Z -> {
                        if (!((Boolean)state.getValue((Property)AXIS_Z)).booleanValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.Axis.X -> {
                        if (!((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
            return super.canBeReplaced(state, context);
        }
    }

    private static class TomatoRopeBlock
    extends TomatoLoggedBlock
    implements IRopeConnection {
        public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
        public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
        public static final BooleanProperty WEST = BlockStateProperties.WEST;
        public static final BooleanProperty EAST = BlockStateProperties.EAST;
        public static final BooleanProperty KNOT = ModBlockProperties.KNOT;

        public TomatoRopeBlock(BlockBehaviour.Properties properties) {
            super(properties);
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)KNOT, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public Block getInnerBlock() {
            return (Block)ModRegistry.ROPE.get();
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, KNOT});
            super.createBlockStateDefinition(builder);
        }

        @Override
        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            super.updateShape(state, facing, facingState, level, currentPos, facingPos);
            if (facing.getAxis() == Direction.Axis.Y) {
                return state;
            }
            BlockState newState = (BlockState)state.setValue((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.shouldConnectToFace(state, facingState, facingPos, facing, (LevelReader)level)));
            boolean hasKnot = (Boolean)newState.getValue((Property)SOUTH) != false || (Boolean)newState.getValue((Property)EAST) != false || (Boolean)newState.getValue((Property)NORTH) != false || (Boolean)newState.getValue((Property)WEST) != false;
            newState = (BlockState)newState.setValue((Property)KNOT, (Comparable)Boolean.valueOf(hasKnot));
            return newState;
        }

        @Override
        public boolean canSideAcceptConnection(BlockState state, Direction direction) {
            return true;
        }
    }

    private static abstract class TomatoLoggedBlock
    extends TomatoVineBlock {
        public TomatoLoggedBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public void attemptRopeClimb(ServerLevel level, BlockPos pos, RandomSource random) {
            super.attemptRopeClimb(level, pos, random);
        }

        public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            return (belowState.getBlock() instanceof TomatoVineBlock || super.canSurvive((BlockState)state.setValue((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(false)), level, pos)) && this.hasGoodCropConditions(level, pos);
        }

        public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
            super.playerDestroy(level, player, pos, (BlockState)state.setValue((Property)TomatoVineBlock.ROPELOGGED, (Comparable)Boolean.valueOf(false)), blockEntity, stack);
        }

        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            this.playerWillDestroy(level, pos, state, player);
            return level.setBlock(pos, this.getInnerBlock().withPropertiesOf(state), level.isClientSide ? 11 : 3);
        }

        public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, null, (ItemStack)ItemStack.EMPTY);
                level.setBlockAndUpdate(pos, this.getInnerBlock().withPropertiesOf(state));
            }
        }

        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (!state.canSurvive((LevelReader)level, currentPos)) {
                level.scheduleTick(currentPos, (Block)this, 1);
            }
            return state;
        }

        public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
            state = ((Block)CompatObjects.TOMATO_CROP.get()).withPropertiesOf(state);
            return state.getDrops(builder);
        }

        public abstract Block getInnerBlock();
    }
}

