/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.worldgen.ISpawnBoxStructure;
import net.mehvahdjukaar.moonlight.api.worldgen.SpawnBoxSettings;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgen;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.jetbrains.annotations.NotNull;

public class GalleonStructure
extends Structure
implements ISpawnBoxStructure {
    public static final MapCodec<GalleonStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GalleonStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(structure -> structure.yOffset), (App)Climate.ParameterPoint.CODEC.optionalFieldOf("biome_point").forGetter(structure -> structure.biomePoint), (App)Codec.BOOL.optionalFieldOf("require_sea_level", (Object)true).forGetter(structure -> structure.requireSeaLevel), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings), (App)SpawnBoxSettings.CODEC.optionalFieldOf("spawn_boxes", (Object)SpawnBoxSettings.EMPTY).forGetter(structure -> structure.spawnBoxSettings)).apply((Applicative)instance, GalleonStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int yOffset;
    private final Optional<Climate.ParameterPoint> biomePoint;
    private final boolean requireSeaLevel;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;
    private final SpawnBoxSettings spawnBoxSettings;
    private static final Component OMINOUS_FLAG_PATTERN_NAME = Component.translatable((String)"block.supplementaries.ominous_flag").withStyle(ChatFormatting.GOLD);

    public GalleonStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int yOffset, Optional<Climate.ParameterPoint> biomePoint, boolean requireSeaLevel, DimensionPadding dimensionPadding, LiquidSettings liquidSettings, SpawnBoxSettings spawnBoxSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.yOffset = yOffset;
        this.biomePoint = biomePoint;
        this.requireSeaLevel = requireSeaLevel;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
        this.spawnBoxSettings = spawnBoxSettings;
    }

    public StructureType<?> type() {
        return ModWorldgen.GALLEON_STRUCTURE.get();
    }

    @NotNull
    public SpawnBoxSettings ml$getSpawnBoxSettings() {
        return this.spawnBoxSettings;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        Optional<BlockPos> suitablePosition = this.getSuitablePosition(context);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        BlockPos blockPos = suitablePosition.get();
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)10, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)64, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    private Optional<BlockPos> getSuitablePosition(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator generator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState randomState = context.randomState();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        int y = generator.getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState) + 1;
        int seaLevel = context.chunkGenerator().getSeaLevel();
        if (this.requireSeaLevel && y != seaLevel) {
            return Optional.empty();
        }
        Climate.TargetPoint paramAtPos = context.randomState().sampler().sample(QuartPos.fromBlock((int)x), QuartPos.fromBlock((int)y), QuartPos.fromBlock((int)z));
        if (this.biomePoint.isPresent() && !GalleonStructure.containsPoint(this.biomePoint.get(), paramAtPos)) {
            return Optional.empty();
        }
        return Optional.of(new BlockPos(x, y + this.yOffset, z));
    }

    private static boolean containsPoint(Climate.ParameterPoint cube, Climate.TargetPoint point) {
        return cube.continentalness().min() <= point.continentalness() && cube.continentalness().max() >= point.continentalness() && cube.erosion().min() <= point.erosion() && cube.erosion().max() >= point.erosion() && cube.temperature().min() <= point.temperature() && cube.temperature().max() >= point.temperature() && cube.humidity().min() <= point.humidity() && cube.humidity().max() >= point.humidity() && cube.weirdness().min() <= point.weirdness() && cube.weirdness().max() >= point.weirdness() && cube.depth().min() <= point.depth() && cube.depth().max() >= point.depth();
    }

    public static ItemStack getGalleonFlag(HolderGetter<BannerPattern> patternRegistry) {
        ItemStack itemStack = new ItemStack((ItemLike)ModRegistry.FLAGS.get(DyeColor.WHITE).get());
        BannerPatternLayers bannerPatternLayers = new BannerPatternLayers.Builder().addIfRegistered(patternRegistry, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.GREEN).addIfRegistered(patternRegistry, BannerPatterns.STRIPE_LEFT, DyeColor.GRAY).addIfRegistered(patternRegistry, BannerPatterns.TRIANGLES_TOP, DyeColor.GRAY).addIfRegistered(patternRegistry, BannerPatterns.TRIANGLES_BOTTOM, DyeColor.GRAY).addIfRegistered(patternRegistry, BannerPatterns.STRAIGHT_CROSS, DyeColor.BLACK).addIfRegistered(patternRegistry, BannerPatterns.HALF_VERTICAL_MIRROR, DyeColor.GRAY).addIfRegistered(patternRegistry, BannerPatterns.BORDER, DyeColor.BLACK).build();
        itemStack.set(DataComponents.BANNER_PATTERNS, (Object)bannerPatternLayers);
        itemStack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        itemStack.set(DataComponents.ITEM_NAME, (Object)OMINOUS_FLAG_PATTERN_NAME);
        return itemStack;
    }

    public static class Type
    implements StructureType<GalleonStructure> {
        public MapCodec<GalleonStructure> codec() {
            return CODEC;
        }
    }
}

