/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.PlayerAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlingshotItem
extends ProjectileWeaponItem
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useDuration = this.getUseDuration(stack, entity) - timeCharged;
            float power = SlingshotItem.getPowerForTime(useDuration, stack, entity);
            if ((double)power >= 0.085) {
                if (this.tryShootingParrot(player, stack, power)) {
                    return;
                }
                ItemStack ammo = player.getProjectile(stack);
                if (!ammo.isEmpty()) {
                    List projectiles = SlingshotItem.draw((ItemStack)stack, (ItemStack)ammo, (LivingEntity)player);
                    power = SlingshotItem.applyPowerModifiers(stack, power);
                    if (!projectiles.isEmpty()) {
                        this.shoot(player.serverLevel(), (LivingEntity)player, player.getUsedItemHand(), stack, projectiles, power, 1.0f, false, null);
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                    }
                }
            }
        }
    }

    private static float applyPowerModifiers(ItemStack stack, float power) {
        boolean noGravity = EnchantmentHelper.has((ItemStack)stack, ModEnchantments.PROJECTILE_NO_GRAVITY.get());
        return power *= (float)((CommonConfigs.Tools.SLINGSHOT_RANGE.get() + (noGravity ? 0.5 : 0.0)) * 1.1);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        return new SlingshotProjectileEntity(level, ammo, weapon, shooter);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        if (target != null) {
            double d = target.getX() - shooter.getX();
            double e = target.getZ() - shooter.getZ();
            double f = Math.sqrt(d * d + e * e);
            double g = target.getY(0.3333333333333333) - projectile.getY() + f * (double)0.2f;
            vector3f = SlingshotItem.getProjectileShotVector(shooter, new Vec3(d, g, e), angle);
        } else {
            vector3f = SlingshotItem.getShootVector(shooter, angle);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float pitch = SlingshotItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), ModSounds.SLINGSHOT_SHOOT.get(), shooter.getSoundSource(), 1.0f, pitch);
    }

    private static Vector3f getShootVector(LivingEntity shooter, float angle) {
        Vec3 vec3 = shooter.getUpVector(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        Vec3 vec32 = shooter.getViewVector(1.0f);
        Vector3f vector3f = vec32.toVector3f().rotate((Quaternionfc)quaternionf);
        return vector3f;
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : SlingshotItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public static float getPowerForTime(float charge, ItemStack stack, LivingEntity entity) {
        float f = charge / (float)SlingshotItem.getChargeDuration(stack, entity);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeDuration(ItemStack stack, LivingEntity shooter) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)CommonConfigs.Tools.SLINGSHOT_CHARGE.get().intValue()) / 20.0f;
        return Mth.floor((float)(f * 20.0f));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        ItemStack itemstack = player.getItemInHand(hand);
        boolean flag = this.getAllSupportedProjectiles().test(player.getProjectile(itemstack));
        if (!flag) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        player.level().playSound(player, (Entity)player, this.getChargeSound(itemstack), SoundSource.PLAYERS, 1.0f, 1.0f * (1.0f / (level.random.nextFloat() * 0.3f + 0.9f)));
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public SoundEvent getChargeSound(ItemStack stack) {
        Pair pair = EnchantmentHelper.getHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME);
        int i = pair == null ? 0 : (Integer)pair.getSecond();
        return switch (i) {
            case 0 -> ModSounds.SLINGSHOT_CHARGE_0.get();
            case 1 -> ModSounds.SLINGSHOT_CHARGE_1.get();
            case 2 -> ModSounds.SLINGSHOT_CHARGE_2.get();
            default -> ModSounds.SLINGSHOT_CHARGE_3.get();
        };
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return s -> {
            Item i = s.getItem();
            if (i instanceof ThrowablePotionItem) {
                return CommonConfigs.Tools.SLINGSHOT_POTIONS.get();
            }
            if (i instanceof BombItem) {
                return CommonConfigs.Tools.SLINGSHOT_BOMBS.get();
            }
            if (i instanceof SnowballItem) {
                return CommonConfigs.Tools.SLINGSHOT_SNOWBALL.get();
            }
            if (i instanceof EnderpearlItem) {
                return CommonConfigs.Tools.SLINGSHOT_ENDERPEARLS.get();
            }
            if (i instanceof FireChargeItem) {
                return CommonConfigs.Tools.SLINGSHOT_FIRECHARGE.get();
            }
            if (i instanceof DispensibleContainerItem && i.hasCraftingRemainingItem()) {
                return CommonConfigs.Tools.SLINGSHOT_BUCKETS.get();
            }
            if (s.is(ModTags.SLINGSHOT_DAMAGEABLE)) {
                return true;
            }
            return !(i instanceof DispensibleContainerItem) && !s.is(ModTags.SLINGSHOT_BLACKLIST) && i instanceof BlockItem || AdditionalItemPlacementsAPI.hasBehavior((Item)i) || InteractEventsHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int getDefaultProjectileRange() {
        return 10;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            model.leftArm.yRot = MthUtils.wrapRad((float)(0.1f + model.head.yRot));
            model.leftArm.xRot = MthUtils.wrapRad((float)(-1.5707964f + model.head.xRot));
            return true;
        }
        return false;
    }

    public boolean isTwoHanded() {
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            model.rightArm.yRot = MthUtils.wrapRad((float)(-0.1f + model.head.yRot));
            model.rightArm.xRot = MthUtils.wrapRad((float)(-1.5707964f + model.head.xRot));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(Player entity, ItemStack stack, InteractionHand hand, HumanoidArm humanoidArm, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.isUsingItem() && entity.getUseItemRemainingTicks() > 0 && entity.getUsedItemHand() == hand) {
            float useDuration = (float)stack.getUseDuration((LivingEntity)entity) - ((float)entity.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float power = SlingshotItem.getPowerForTime(useDuration, stack, (LivingEntity)entity);
            if (power > 0.1f) {
                float f15 = Mth.sin((float)((useDuration - 0.1f) * 1.3f));
                float f18 = power - 0.1f;
                float f20 = f15 * f18;
                matrixStack.translate(0.0f, f20 * 0.004f, 0.0f);
            }
            matrixStack.translate(0.0f, 0.0f, power * 0.04f);
            matrixStack.scale(1.0f, 1.0f, 1.0f + power * 0.2f);
        }
    }

    private boolean tryShootingParrot(ServerPlayer player, ItemStack stack, float power) {
        CompoundTag[] parrots = new CompoundTag[]{player.getShoulderEntityLeft(), player.getShoulderEntityRight()};
        if (parrots[0].isEmpty() && parrots[1].isEmpty()) {
            return false;
        }
        power = SlingshotItem.applyPowerModifiers(stack, power);
        this.shootParrots(player.serverLevel(), player, player.getUsedItemHand(), stack, parrots, power, 1.0f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    private void shootParrots(ServerLevel level, ServerPlayer shooter, InteractionHand hand, ItemStack weapon, CompoundTag[] parrots, float velocity, float inaccuracy) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float g = parrots.length == 1 ? 0.0f : 2.0f * f / (float)(parrots.length - 1);
        float h = (float)((parrots.length - 1) % 2) * g / 2.0f;
        float i = 1.0f;
        boolean wasParrot = false;
        for (int j = 0; j < parrots.length; ++j) {
            CompoundTag itemStack = parrots[j];
            if (itemStack.isEmpty()) continue;
            float k = h + i * (float)((j + 1) / 2) * g;
            i = -i;
            Entity projectile = this.createEntityOnShoulder(shooter, j == 0);
            this.shootParrot((LivingEntity)shooter, projectile, j, velocity, inaccuracy, k);
            level.addFreshEntity(projectile);
            weapon.hurtAndBreak(1, (LivingEntity)shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (projectile instanceof Parrot) {
                wasParrot = true;
            }
            if (weapon.isEmpty()) break;
        }
        if (wasParrot) {
            Utils.awardAdvancement((ServerPlayer)shooter, (ResourceLocation)Supplementaries.res("husbandry/angry_birds"));
        }
    }

    protected void shootParrot(LivingEntity shooter, Entity parrot, int index, float velocity, float inaccuracy, float angle) {
        Vector3f vector3f = SlingshotItem.getShootVector(shooter, angle);
        RandomSource random = parrot.getRandom();
        float x = vector3f.x();
        float y = vector3f.y();
        float z = vector3f.z();
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z).normalize().add(random.triangle(0.0, 0.0172275 * (double)inaccuracy), random.triangle(0.0, 0.0172275 * (double)inaccuracy), random.triangle(0.0, 0.0172275 * (double)inaccuracy)).scale((double)(velocity *= 4.0f));
        parrot.setDeltaMovement(vec3);
        parrot.hasImpulse = true;
        double d = vec3.horizontalDistance();
        parrot.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        parrot.setXRot((float)(Mth.atan2((double)vec3.y, (double)d) * 57.2957763671875));
        parrot.yRotO = parrot.getYRot();
        parrot.xRotO = parrot.getXRot();
        float pitch = SlingshotItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), ModSounds.SLINGSHOT_SHOOT.get(), shooter.getSoundSource(), 1.0f, pitch);
    }

    @Nullable
    private Entity createEntityOnShoulder(ServerPlayer player, boolean left) {
        CompoundTag entityCompound = left ? player.getShoulderEntityLeft() : player.getShoulderEntityRight();
        Optional e = EntityType.create((CompoundTag)entityCompound, (Level)player.level());
        if (e.isPresent()) {
            if (left) {
                ((PlayerAccessor)player).invokeSetShoulderEntityLeft(new CompoundTag());
            } else {
                ((PlayerAccessor)player).invokeSetShoulderEntityRight(new CompoundTag());
            }
            Entity entity = (Entity)e.get();
            if (entity instanceof TamableAnimal) {
                TamableAnimal ta = (TamableAnimal)entity;
                ta.setOwnerUUID(player.getUUID());
                ta.setOrderedToSit(true);
            }
            entity.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            player.serverLevel().addWithUUID(entity);
            return entity;
        }
        return null;
    }
}

